/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.OrderedComparator;
import org.junit.jupiter.api.Test;

public class RoutesConfigurationBuilderTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testRoutesConfigurationOnException() throws Exception {
        ArrayList<Object> routes = new ArrayList<Object>();
        routes.add(new RouteBuilder(){

            public void configure() {
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Foo"));
            }
        });
        routes.add(new RouteBuilder(){

            public void configure() {
                this.from("direct:start2").throwException((Exception)new IllegalArgumentException("Foo2"));
            }
        });
        routes.add(new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().onException(Exception.class).handled(true).to("mock:error");
            }
        });
        this.context.start();
        routes.sort((Comparator<Object>)OrderedComparator.get());
        for (RoutesBuilder routesBuilder : routes) {
            if (!(routesBuilder instanceof RouteConfigurationsBuilder)) continue;
            RouteConfigurationsBuilder rcb = (RouteConfigurationsBuilder)routesBuilder;
            this.context.addRoutesConfigurations(rcb);
        }
        for (RoutesBuilder routesBuilder : routes) {
            this.context.addRoutes(routesBuilder);
        }
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRoutesConfigurationOnCompletion() throws Exception {
        ArrayList<Object> routes = new ArrayList<Object>();
        routes.add(new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        });
        routes.add(new RouteBuilder(){

            public void configure() {
                ((OnCompletionDefinition)this.from("direct:start2").onCompletion().to("mock:done2")).end().to("mock:result");
            }
        });
        routes.add(new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().onCompletion().to("mock:done");
            }
        });
        this.context.start();
        routes.sort((Comparator<Object>)OrderedComparator.get());
        for (RoutesBuilder routesBuilder : routes) {
            if (!(routesBuilder instanceof RouteConfigurationsBuilder)) continue;
            RouteConfigurationsBuilder rcb = (RouteConfigurationsBuilder)routesBuilder;
            this.context.addRoutesConfigurations(rcb);
        }
        for (RoutesBuilder routesBuilder : routes) {
            this.context.addRoutes(routesBuilder);
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.getMockEndpoint("mock:done").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:done2").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRoutesConfigurationIntercept() throws Exception {
        ArrayList<Object> routes = new ArrayList<Object>();
        routes.add(new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").setBody((Expression)this.constant("A"))).setBody((Expression)this.constant("B"))).to("mock:result");
            }
        });
        routes.add(new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start2").setBody((Expression)this.constant("C"))).setBody((Expression)this.constant("D"))).to("mock:result");
            }
        });
        routes.add(new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().intercept().to("mock:step");
            }
        });
        this.context.start();
        routes.sort((Comparator<Object>)OrderedComparator.get());
        for (RoutesBuilder routesBuilder : routes) {
            if (!(routesBuilder instanceof RouteConfigurationsBuilder)) continue;
            RouteConfigurationsBuilder rcb = (RouteConfigurationsBuilder)routesBuilder;
            this.context.addRoutesConfigurations(rcb);
        }
        for (RoutesBuilder routesBuilder : routes) {
            this.context.addRoutes(routesBuilder);
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.getMockEndpoint("mock:step").expectedBodiesReceived(new Object[]{"Hello World", "A", "B", "Bye World", "C", "D"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRoutesConfigurationInterceptFrom() throws Exception {
        ArrayList<Object> routes = new ArrayList<Object>();
        routes.add(new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("seda:start").setBody((Expression)this.constant("A"))).setBody((Expression)this.constant("B"))).to("mock:result");
            }
        });
        routes.add(new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start2").setBody((Expression)this.constant("C"))).setBody((Expression)this.constant("D"))).to("mock:result");
            }
        });
        routes.add(new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().interceptFrom("direct*").to("mock:step");
            }
        });
        this.context.start();
        routes.sort((Comparator<Object>)OrderedComparator.get());
        for (RoutesBuilder routesBuilder : routes) {
            if (!(routesBuilder instanceof RouteConfigurationsBuilder)) continue;
            RouteConfigurationsBuilder rcb = (RouteConfigurationsBuilder)routesBuilder;
            this.context.addRoutesConfigurations(rcb);
        }
        for (RoutesBuilder routesBuilder : routes) {
            this.context.addRoutes(routesBuilder);
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.getMockEndpoint("mock:step").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRoutesConfigurationInterceptSendTo() throws Exception {
        ArrayList<Object> routes = new ArrayList<Object>();
        routes.add(new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").setBody((Expression)this.constant("A"))).to("mock:foo")).setBody((Expression)this.constant("B"))).to("mock:bar")).to("mock:result");
            }
        });
        routes.add(new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start2").setBody((Expression)this.constant("C"))).to("mock:foo")).setBody((Expression)this.constant("D"))).to("mock:bar")).to("mock:result");
            }
        });
        routes.add(new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().interceptSendToEndpoint("mock:foo").to("mock:step");
            }
        });
        this.context.start();
        routes.sort((Comparator<Object>)OrderedComparator.get());
        for (RoutesBuilder routesBuilder : routes) {
            if (!(routesBuilder instanceof RouteConfigurationsBuilder)) continue;
            RouteConfigurationsBuilder rcb = (RouteConfigurationsBuilder)routesBuilder;
            this.context.addRoutesConfigurations(rcb);
        }
        for (RoutesBuilder routesBuilder : routes) {
            this.context.addRoutes(routesBuilder);
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.getMockEndpoint("mock:step").expectedBodiesReceived(new Object[]{"A", "C"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }
}

