/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.support.OrderedComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutesConfigurationBuilderIdOrPatternTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testRoutesConfigurationOnException() throws Exception {
        ArrayList<Object> routes = new ArrayList<Object>();
        routes.add(new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").throwException((Exception)new IllegalArgumentException("Foo"));
            }
        });
        routes.add(new RouteBuilder(){

            public void configure() {
                this.from("direct:start2").routeId("foo2").routeConfigurationId("handleError").throwException((Exception)new IllegalArgumentException("Foo2"));
            }
        });
        routes.add(new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration("handleError").onException(Exception.class).handled(true).to("mock:error");
            }
        });
        this.context.start();
        routes.sort((Comparator<Object>)OrderedComparator.get());
        for (RoutesBuilder routesBuilder : routes) {
            if (!(routesBuilder instanceof RouteConfigurationsBuilder)) continue;
            RouteConfigurationsBuilder rcb = (RouteConfigurationsBuilder)routesBuilder;
            this.context.addRoutesConfigurations(rcb);
        }
        for (RoutesBuilder routesBuilder : routes) {
            this.context.addRoutes(routesBuilder);
        }
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Bye World"});
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should throw exception");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNull((Object)this.context.getRoute("foo").getConfigurationId());
        Assertions.assertEquals((Object)"handleError", (Object)this.context.getRoute("foo2").getConfigurationId());
    }

    @Test
    public void testRoutesConfigurationOnExceptionPattern() throws Exception {
        ArrayList<Object> routes = new ArrayList<Object>();
        routes.add(new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").routeConfigurationId("general*").throwException((Exception)new IllegalArgumentException("Foo"));
            }
        });
        routes.add(new RouteBuilder(){

            public void configure() {
                this.from("direct:start2").routeId("foo2").routeConfigurationId("io*").throwException((Exception)new IOException("Foo2"));
            }
        });
        routes.add(new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration("generalError").onException(Exception.class).handled(true).to("mock:error");
                this.routeConfiguration("ioError").onException(IOException.class).maximumRedeliveries(3).redeliveryDelay(0L).handled(true).to("mock:io");
            }
        });
        this.context.start();
        routes.sort((Comparator<Object>)OrderedComparator.get());
        for (RoutesBuilder routesBuilder : routes) {
            if (!(routesBuilder instanceof RouteConfigurationsBuilder)) continue;
            RouteConfigurationsBuilder rcb = (RouteConfigurationsBuilder)routesBuilder;
            this.context.addRoutesConfigurations(rcb);
        }
        for (RoutesBuilder routesBuilder : routes) {
            this.context.addRoutes(routesBuilder);
        }
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:io").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"generalError", (Object)this.context.getRoute("foo").getConfigurationId());
        Assertions.assertEquals((Object)"ioError", (Object)this.context.getRoute("foo2").getConfigurationId());
    }

    @Test
    public void testRoutesConfigurationOnExceptionDefault() throws Exception {
        ArrayList<Object> routes = new ArrayList<Object>();
        routes.add(new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").throwException((Exception)new IllegalArgumentException("Foo"));
            }
        });
        routes.add(new RouteBuilder(){

            public void configure() {
                this.from("direct:start2").routeId("foo2").throwException((Exception)new IOException("Foo2"));
            }
        });
        routes.add(new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().onException(Exception.class).handled(true).to("mock:error");
                this.routeConfiguration("ioError").onException(IOException.class).maximumRedeliveries(3).redeliveryDelay(0L).handled(true).to("mock:io");
            }
        });
        this.context.start();
        routes.sort((Comparator<Object>)OrderedComparator.get());
        for (RoutesBuilder routesBuilder : routes) {
            if (!(routesBuilder instanceof RouteConfigurationsBuilder)) continue;
            RouteConfigurationsBuilder rcb = (RouteConfigurationsBuilder)routesBuilder;
            this.context.addRoutesConfigurations(rcb);
        }
        for (RoutesBuilder routesBuilder : routes) {
            this.context.addRoutes(routesBuilder);
        }
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:io").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"<default>", (Object)this.context.getRoute("foo").getConfigurationId());
        Assertions.assertEquals((Object)"<default>", (Object)this.context.getRoute("foo2").getConfigurationId());
        this.context.removeRoute("foo2");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start2").routeId("foo2").routeConfigurationId("ioError").throwException((Exception)new IOException("Foo2"));
            }
        });
        this.resetMocks();
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:io").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"<default>", (Object)this.context.getRoute("foo").getConfigurationId());
        Assertions.assertEquals((Object)"ioError", (Object)this.context.getRoute("foo2").getConfigurationId());
    }

    @Test
    public void testRoutesConfigurationIdClash() throws Exception {
        RouteConfigurationBuilder rcb = new RouteConfigurationBuilder(){

            public void configuration() {
                this.routeConfiguration().onException(Exception.class).handled(true).to("mock:foo");
                this.routeConfiguration("foo").onException(IOException.class).handled(true).to("mock:foo");
                this.routeConfiguration("bar").onException(FileNotFoundException.class).handled(true).to("mock:bar");
                this.routeConfiguration("foo").onException(IllegalArgumentException.class).handled(true).to("mock:foo");
            }
        };
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.context.addRoutesConfigurations((RouteConfigurationsBuilder)rcb), (String)"Should throw exception");
        Assertions.assertEquals((Object)"Route configuration already exists with id: foo", (Object)e.getMessage());
    }
}

