/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.support.RoutePolicySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RouteTemplateDefinitionTest {
    RouteTemplateDefinitionTest() {
    }

    @Test
    void testDeepCopyMutableProperties() {
        RouteDefinition route = new RouteDefinition();
        route.setTemplateParameters(Map.of("parameter", "parameterValue"));
        route.setRouteProperties(List.of(new PropertyDefinition("property", "propertyValue")));
        route.setRoutePolicies(List.of(new RoutePolicySupport(){}));
        route.setInput(new FromDefinition("direct://fromEndpoint"));
        route.setOutputs(List.of(new CopyableDefinitionProcessDefinition(), new NonCopyableProcessDefinition()));
        RouteTemplateDefinition routeTemplate = new RouteTemplateDefinition();
        routeTemplate.setRoute(route);
        RouteDefinition routeCopy = routeTemplate.asRouteDefinition();
        Assertions.assertNotSame((Object)route.getTemplateParameters(), (Object)routeCopy.getTemplateParameters());
        Assertions.assertEquals((Object)route.getTemplateParameters(), (Object)routeCopy.getTemplateParameters());
        Assertions.assertNotSame((Object)route.getRouteProperties(), (Object)routeCopy.getRouteProperties());
        Assertions.assertEquals((Object)route.getRouteProperties(), (Object)routeCopy.getRouteProperties());
        Assertions.assertNotSame((Object)route.getRoutePolicies(), (Object)routeCopy.getRoutePolicies());
        Assertions.assertEquals((Object)route.getRoutePolicies(), (Object)routeCopy.getRoutePolicies());
        Assertions.assertNotSame((Object)route.getInput(), (Object)routeCopy.getInput());
        Assertions.assertEquals((Object)route.getInput().getUri(), (Object)routeCopy.getInput().getUri());
        Assertions.assertNotSame((Object)route.getOutputs(), (Object)routeCopy.getOutputs());
        Assertions.assertEquals((int)2, (int)routeCopy.getOutputs().size());
        Assertions.assertInstanceOf(CopyableDefinitionProcessDefinition.class, routeCopy.getOutputs().get(0));
        Assertions.assertNotSame(route.getOutputs().get(0), routeCopy.getOutputs().get(0));
        Assertions.assertEquals((Object)((ProcessorDefinition)route.getOutputs().get(0)).getId(), (Object)((ProcessorDefinition)routeCopy.getOutputs().get(0)).getId());
        Assertions.assertSame(route.getOutputs().get(1), routeCopy.getOutputs().get(1));
    }

    private static final class CopyableDefinitionProcessDefinition
    extends ProcessorDefinition<CopyableDefinitionProcessDefinition> {
        public CopyableDefinitionProcessDefinition() {
            this.setId(UUID.randomUUID().toString());
        }

        public ProcessorDefinition<?> copyDefinition() {
            CopyableDefinitionProcessDefinition copy = new CopyableDefinitionProcessDefinition();
            copy.setId(this.getId());
            return copy;
        }

        public String getShortName() {
            return ((Object)((Object)this)).toString();
        }

        public List<ProcessorDefinition<?>> getOutputs() {
            return Collections.emptyList();
        }
    }

    private static final class NonCopyableProcessDefinition
    extends ProcessorDefinition<NonCopyableProcessDefinition> {
        private NonCopyableProcessDefinition() {
        }

        public String getShortName() {
            return ((Object)((Object)this)).toString();
        }

        public List<ProcessorDefinition<?>> getOutputs() {
            return Collections.emptyList();
        }

        public ProcessorDefinition<?> copyDefinition() {
            return this;
        }
    }
}

