/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class RoutePropertiesTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testRouteProperties() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("route-id").routeProperty("key1", "val1").routeProperty("key2", "val2").to("mock:output");
            }
        });
        this.context.start();
        RouteDefinition definition = this.context.getRouteDefinition("route-id");
        Route route = this.context.getRoute("route-id");
        Assertions.assertNotNull((Object)definition.getRouteProperties());
        Assertions.assertEquals((int)2, (int)definition.getRouteProperties().size());
        Assertions.assertNotNull((Object)route.getProperties());
        Assertions.assertEquals((Object)"val1", route.getProperties().get("key1"));
        Assertions.assertEquals((Object)"val2", route.getProperties().get("key2"));
    }

    @DisplayName(value="Checks that trying to use a reserved property leads to failure")
    @Test
    public void testRoutePropertiesFailure() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("route-id").routeProperty("id", "the id").to("mock:output");
            }
        });
        Assertions.assertThrows(FailedToCreateRouteException.class, () -> this.context.start(), (String)"Should have prevented setting a property with a reserved name");
    }
}

