/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.builder.TemplatedRouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Test;

public class RouteConfigurationOnExceptionTest
extends ContextTestSupport {
    protected RouteBuilder[] createRouteBuilders() {
        return new RouteBuilder[]{new RouteBuilder(){

            public void configure() {
                this.routeTemplate("route-template").from("direct:start-template").routeConfigurationId("my-error-handler").throwException(RuntimeException.class, "Expected Error");
            }
        }, new RouteBuilder(){

            public void configure() {
                this.routeTemplate("route-template-parameter").templateParameter("configuration-id").templateParameter("route-id").from("direct:start-template-parameter").routeId("{{route-id}}").routeConfigurationId("{{configuration-id}}").throwException(RuntimeException.class, "Expected Error");
            }
        }, new RouteBuilder(){

            public void configure() {
                TemplatedRouteBuilder.builder((CamelContext)RouteConfigurationOnExceptionTest.this.context, (String)"route-template").routeId("my-test-file-route").add();
            }
        }, new RouteBuilder(){

            public void configure() {
                TemplatedRouteBuilder.builder((CamelContext)RouteConfigurationOnExceptionTest.this.context, (String)"route-template-parameter").routeId("my-test-file-route-parameter").parameter("configuration-id", (Object)"my-error-handler").parameter("route-id", (Object)"custom-route-id").add();
            }
        }, new RouteBuilder(){

            public void configure() {
                this.from("direct:start-normal").routeConfigurationId("my-error-handler").throwException(RuntimeException.class, "Expected Error");
            }
        }, new RouteConfigurationBuilder(){

            public void configuration() {
                ((OnExceptionDefinition)this.routeConfiguration("my-error-handler").onException(Exception.class).handled(true).transform((Expression)this.constant("Error Received"))).to("mock:result");
            }
        }};
    }

    @Test
    void testRouteTemplateCanSupportRouteConfiguration() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Error Received"});
        this.template.sendBody("direct:start-template", (Object)"foo");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void testRouteTemplateCanSupportRouteConfigurationWithParameter() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Error Received"});
        this.template.sendBody("direct:start-template-parameter", (Object)"foo");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void testNormalRouteCanSupportRouteConfiguration() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Error Received"});
        this.template.sendBody("direct:start-normal", (Object)"foo");
        this.assertMockEndpointsSatisfied();
    }
}

