/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.OnCompletionTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteConfigurationOnCompletionTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        camelContext.addRoutes((RoutesBuilder)new RouteConfigurationBuilder(){

            public void configuration() {
                ((OnCompletionDefinition)this.routeConfiguration().onCompletion().onCompleteOnly().to("log:ok")).to("mock:ok");
                ((OnCompletionDefinition)this.routeConfiguration().onCompletion().onFailureOnly().to("log:fail")).to("mock:fail");
            }
        });
        return camelContext;
    }

    @Test
    public void testOk() throws Exception {
        this.getMockEndpoint("mock:ok").expectedMessageCount(1);
        this.getMockEndpoint("mock:fail").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFail() throws Exception {
        this.getMockEndpoint("mock:ok").expectedMessageCount(0);
        this.getMockEndpoint("mock:fail").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"Kaboom"), (String)"Should have thrown exception");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOkAndFail() throws Exception {
        this.getMockEndpoint("mock:ok").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:fail").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"Kaboom"), (String)"Should throw exception");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("direct:end");
                ((RouteDefinition)this.from("direct:end").process((Processor)new OnCompletionTest.MyProcessor())).to("mock:result");
            }
        };
    }
}

