/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultPackageScanClassResolver;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSanityCheckerTest {
    private static final Logger LOG = LoggerFactory.getLogger(ModelSanityCheckerTest.class);

    private Set<Class<?>> discoverJaxbClasses() {
        DefaultPackageScanClassResolver resolver = new DefaultPackageScanClassResolver();
        resolver.start();
        String[] packages = "org.apache.camel:org.apache.camel.model:org.apache.camel.model.app:org.apache.camel.model.cloud:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.errorhandler:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.model.rest:org.apache.camel.model.transformer:org.apache.camel.model.validator".split(":");
        return resolver.findAnnotated(XmlAccessorType.class, packages);
    }

    @Test
    public void testSanity() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        BeanIntrospection bi = PluginHelper.getBeanIntrospection((CamelContext)context);
        Set<Class<?>> classes = this.discoverJaxbClasses();
        Assertions.assertNotNull(classes);
        Assertions.assertTrue((classes.size() > 140 ? 1 : 0) != 0, (String)("There should be > 140 classes, was: " + classes.size()));
        for (Class<?> clazz : classes) {
            boolean elementRef;
            boolean element;
            boolean attribute;
            if (clazz == ProcessorDefinition.class || clazz == RouteDefinition.class) continue;
            for (Field field : clazz.getDeclaredFields()) {
                LOG.debug("Class {} has field {}", (Object)clazz.getName(), (Object)field.getName());
                attribute = field.getAnnotation(XmlAttribute.class) != null;
                element = field.getAnnotation(XmlElement.class) != null;
                boolean bl = elementRef = field.getAnnotation(XmlElementRef.class) != null;
                if (attribute && element || attribute && elementRef || element && elementRef) {
                    Assertions.fail((String)("Class " + clazz.getName() + " has field " + field.getName() + " which has 2+ annotations that are not allowed together."));
                }
                if (!attribute && !element && !elementRef) continue;
                Method getter = bi.getPropertyGetter(clazz, field.getName(), false);
                Method setter = bi.getPropertySetter(clazz, field.getName());
                Assertions.assertNotNull((Object)getter, (String)("Getter " + field.getName() + " on class " + clazz.getName() + " is missing"));
                Assertions.assertNotNull((Object)setter, (String)("Setter " + field.getName() + " on class " + clazz.getName() + " is missing"));
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                LOG.debug("Class {} has method {}", (Object)clazz.getName(), (Object)((Method)accessibleObject).getName());
                if (clazz.getCanonicalName().equals(OptionalIdentifiedDefinition.class.getCanonicalName())) continue;
                attribute = ((Method)accessibleObject).getAnnotation(XmlAttribute.class) != null;
                element = ((Method)accessibleObject).getAnnotation(XmlElement.class) != null;
                elementRef = ((Method)accessibleObject).getAnnotation(XmlElementRef.class) != null;
                Assertions.assertFalse((boolean)attribute, (String)("Class " + clazz.getName() + " has method " + ((Method)accessibleObject).getName() + " should not have @XmlAttribute annotation"));
                Assertions.assertFalse((boolean)element, (String)("Class " + clazz.getName() + " has method " + ((Method)accessibleObject).getName() + " should not have @XmlElement annotation"));
                boolean b = elementRef && !"setOutputs".equals(((Method)accessibleObject).getName());
                Assertions.assertFalse((boolean)b, (String)("Class " + clazz.getName() + " has method " + ((Method)accessibleObject).getName() + " should not have @XmlElementRef annotation"));
            }
        }
        context.stop();
    }
}

