/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.Model;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ModelRouteFilterPatternIncludeExcludeTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        ((Model)context.getCamelContextExtension().getContextPlugin(Model.class)).setRouteFilterPattern("foo*", "jms:*");
        return context;
    }

    @Test
    public void testRouteFilter() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertEquals((int)1, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((Object)"foo", (Object)((RouteDefinition)this.context.getRouteDefinitions().get(0)).getId());
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:foo").routeId("foo").to("mock:foo");
                this.from("direct:bar").routeId("bar").to("mock:bar");
                this.from("jms:beer").routeId("foolish").to("mock:beer");
            }
        };
    }
}

