/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.model.GlobalOptionDefinition;
import org.apache.camel.model.GlobalOptionsDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GlobalOptionsDefinitionTest {
    private static final String LOG_DEBUG_BODY_MAX_CHARS_VALUE = "500";
    private static final String LOG_DEBUG_BODY_MAX_CHARS_DUP_VALUE = "400";
    private GlobalOptionsDefinition instance;
    private List<GlobalOptionDefinition> globalOptions;
    private GlobalOptionDefinition nominalOption;
    private GlobalOptionDefinition duplicateOption;

    @BeforeEach
    public void setup() {
        this.nominalOption = new GlobalOptionDefinition();
        this.nominalOption.setKey("CamelLogDebugBodyMaxChars");
        this.nominalOption.setValue(LOG_DEBUG_BODY_MAX_CHARS_VALUE);
        this.duplicateOption = new GlobalOptionDefinition();
        this.duplicateOption.setKey("CamelLogDebugBodyMaxChars");
        this.duplicateOption.setValue(LOG_DEBUG_BODY_MAX_CHARS_DUP_VALUE);
        this.globalOptions = new ArrayList<GlobalOptionDefinition>();
        this.globalOptions.add(this.nominalOption);
        this.instance = new GlobalOptionsDefinition();
        this.instance.setGlobalOptions(this.globalOptions);
    }

    @Test
    public void asMapShouldCarryOnLogDebugMaxChars() {
        Map map = this.instance.asMap();
        Assertions.assertNotNull((Object)map);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)LOG_DEBUG_BODY_MAX_CHARS_VALUE, map.get("CamelLogDebugBodyMaxChars"));
    }

    @Test
    public void asMapWithDuplicateKeyShouldOverride() {
        this.globalOptions.add(this.duplicateOption);
        Map map = this.instance.asMap();
        Assertions.assertNotNull((Object)map);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)LOG_DEBUG_BODY_MAX_CHARS_DUP_VALUE, map.get("CamelLogDebugBodyMaxChars"));
    }

    @Test
    public void asMapWithNullGlobalOptionsShouldThrowNullPointerException() {
        this.instance.setGlobalOptions(null);
        Assertions.assertThrows(NullPointerException.class, () -> this.instance.asMap());
    }

    @Test
    public void asMapWithEmptyGlobalOptionsShouldReturnEmptyMap() {
        this.globalOptions.clear();
        Map map = this.instance.asMap();
        Assertions.assertNotNull((Object)map);
        Assertions.assertEquals((int)0, (int)map.size());
    }

    @Test
    public void asMapWithNullKeyShouldReturnEmptyMap() {
        this.nominalOption.setKey(null);
        Map map = this.instance.asMap();
        Assertions.assertNotNull((Object)map);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)LOG_DEBUG_BODY_MAX_CHARS_VALUE, map.get(null));
    }
}

