/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.Marshaller;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.XmlTestSupport;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.GroovyExpression;
import org.apache.camel.model.language.XQueryExpression;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GenerateXmlTest
extends XmlTestSupport {
    @Test
    public void testCreateSimpleXml() throws Exception {
        RoutesDefinition context = new RoutesDefinition();
        RouteDefinition route = context.route();
        route.from("seda:a");
        route.filter((ExpressionDefinition)new XQueryExpression("in.header.foo == 'bar'")).to("seda:b");
        route.description("This is a description of the route");
        this.dump((RouteContainer)context);
    }

    @Test
    public void testGroovyFilterXml() throws Exception {
        RoutesDefinition context = new RoutesDefinition();
        RouteDefinition route = context.route();
        route.from("seda:a");
        route.filter((ExpressionDefinition)new GroovyExpression("in.headers.any { h -> h.startsWith('foo') }")).to("seda:b");
        route.description("This is a description of the route");
        List list = route.getOutputs();
        Assertions.assertEquals((int)1, (int)list.size(), (String)("Size of list: " + String.valueOf(list)));
        this.dump((RouteContainer)context);
    }

    protected void dump(RouteContainer context) throws Exception {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter buffer = new StringWriter();
        marshaller.marshal((Object)context, (Writer)buffer);
        this.log.info("Created: {}", (Object)buffer);
        Assertions.assertNotNull((Object)buffer);
        String out = buffer.toString();
        Assertions.assertTrue((out.indexOf("This is a description of the route") > 0 ? 1 : 0) != 0, (String)"Should contain the description");
    }
}

