/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.XmlTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GenerateXmFromCamelContextTest
extends ContextTestSupport {
    @Test
    public void testCreateRouteFromCamelContext() throws Exception {
        List list = this.context.getRouteDefinitions();
        Assertions.assertEquals((int)1, (int)list.size(), (String)("Size of list " + String.valueOf(list)));
        RouteDefinition routeType = (RouteDefinition)list.get(0);
        this.log.info("Found route: {}", (Object)routeType);
        this.dump(routeType);
    }

    protected void dump(Object object) throws Exception {
        JAXBContext jaxbContext = XmlTestSupport.createJaxbContext();
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter buffer = new StringWriter();
        marshaller.marshal(object, (Writer)buffer);
        this.log.info("Created: {}", (Object)buffer);
        Assertions.assertNotNull((Object)buffer);
        String out = buffer.toString();
        Assertions.assertTrue((out.indexOf("<from uri=\"direct:start\"") > 0 ? 1 : 0) != 0, (String)"Should contain from");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((FilterDefinition)this.from("direct:start").filter().xpath("/foo/bar = 'abc'")).to("mock:result");
            }
        };
    }
}

