/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.SplitDefinition;
import org.junit.jupiter.api.Test;

public class TokenizePairTokenSimpleTest
extends ContextTestSupport {
    @Test
    public void testTokenizeConstant() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:start").split().tokenize("B", 2)).to("mock:line");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"aaBaa", "aa"});
        this.template.sendBody("direct:start", (Object)"aaBaaBaaB");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTokenizeSimple() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:start").split().tokenize("${header.test}", 2)).to("mock:line");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"aaBaa", "aa"});
        this.template.sendBodyAndHeader("direct:start", (Object)"aaBaaBaaB", "test", (Object)"B");
        this.assertMockEndpointsSatisfied();
    }
}

