/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.LanguageTestSupport;
import org.junit.jupiter.api.Test;

public class SimpleWhiteSpaceTest
extends LanguageTestSupport {
    @Override
    protected String getLanguageName() {
        return "simple";
    }

    @Test
    public void testExpressionWithSpace() {
        this.exchange.getIn().setBody((Object)"some text");
        this.assertPredicate("${in.body} contains 'some' && ${in.body} contains 'text'", true);
    }

    @Test
    public void testExpressionWithTabs() {
        this.exchange.getIn().setBody((Object)"some text");
        this.assertPredicate("${in.body} contains 'some' &&\t${in.body} contains 'text'", true);
    }

    @Test
    public void testUnixMultiLineExpression() {
        this.exchange.getIn().setBody((Object)"some text");
        this.assertPredicate("${in.body} contains 'some' &&\n${in.body} contains 'text'", true);
    }

    @Test
    public void testWindowsMultiLineExpression() {
        this.exchange.getIn().setBody((Object)"some text");
        this.assertPredicate("${in.body} contains 'some' &&\r\n${in.body} contains 'text'", true);
    }

    @Test
    public void testMacMultiLineExpression() {
        this.exchange.getIn().setBody((Object)"some text");
        this.assertPredicate("${in.body} contains 'some' &&\r${in.body} contains 'text'", true);
    }

    @Test
    public void testExpressionWithMultiLineString() {
        this.exchange.getIn().setBody((Object)"\tsome\nmulti\rline\r\ntext");
        this.assertPredicate("${in.body} == '\tsome\nmulti\rline\r\ntext'", true);
    }
}

