/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.camel.CamelAuthorizationException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.language.bean.RuntimeBeanExpressionException;
import org.apache.camel.language.simple.MyAttachmentMessage;
import org.apache.camel.language.simple.myconverter.MyCustomDate;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.VariableRepository;
import org.apache.camel.spi.VariableRepositoryFactory;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LanguageHelper;
import org.apache.camel.util.InetAddressUtil;
import org.apache.camel.util.StringHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

public class SimpleTest
extends LanguageTestSupport {
    private static final String INDEX_OUT_OF_BOUNDS_ERROR_MSG = "Index 2 out of bounds for length 2";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myAnimal", (Object)new Animal("Donkey", 17));
        return jndi;
    }

    @Test
    public void testSimpleExpressionOrPredicate() {
        Predicate predicate = this.context.resolveLanguage("simple").createPredicate("${header.bar} == 123");
        Assertions.assertTrue((boolean)predicate.matches(this.exchange));
        predicate = this.context.resolveLanguage("simple").createPredicate("${header.bar} == 124");
        Assertions.assertFalse((boolean)predicate.matches(this.exchange));
        Expression expression = this.context.resolveLanguage("simple").createExpression("${body}");
        Assertions.assertEquals((Object)"<hello id='m123'>world!</hello>", (Object)expression.evaluate(this.exchange, String.class));
        expression = this.context.resolveLanguage("simple").createExpression("${body}");
        Assertions.assertEquals((Object)"<hello id='m123'>world!</hello>", (Object)expression.evaluate(this.exchange, String.class));
        expression = this.context.resolveLanguage("simple").createExpression("${body}");
        Assertions.assertEquals((Object)"<hello id='m123'>world!</hello>", (Object)expression.evaluate(this.exchange, String.class));
        predicate = this.context.resolveLanguage("simple").createPredicate("${header.bar} == 123");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)predicate.matches(this.exchange));
        predicate = this.context.resolveLanguage("simple").createPredicate("${header.bar} == 124");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)predicate.matches(this.exchange));
        predicate = this.context.resolveLanguage("simple").createPredicate("${header.bar} == 123");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)predicate.matches(this.exchange));
        predicate = this.context.resolveLanguage("simple").createPredicate("${header.bar} == 124");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)predicate.matches(this.exchange));
    }

    @Test
    public void testResultType() {
        Assertions.assertEquals((int)123, (Integer)((Integer)this.context.resolveLanguage("simple").createExpression("${header.bar}").evaluate(this.exchange, Integer.TYPE)));
        Assertions.assertEquals((Object)"123", (Object)this.context.resolveLanguage("simple").createExpression("${header.bar}").evaluate(this.exchange, String.class));
        Assertions.assertNull((Object)this.context.resolveLanguage("simple").createExpression("${header.bar}").evaluate(this.exchange, Date.class));
        Assertions.assertNull((Object)this.context.resolveLanguage("simple").createExpression("${header.unknown}").evaluate(this.exchange, String.class));
    }

    @Test
    public void testRefExpression() {
        this.assertExpressionResultInstanceOf("${ref:myAnimal}", Animal.class);
        this.assertExpression("${ref:myAnimal}", "Donkey");
        this.assertExpression("${ref:unknown}", null);
        this.assertExpression("Hello ${ref:myAnimal}", "Hello Donkey");
        this.assertExpression("Hello ${ref:unknown}", "Hello ");
    }

    @Test
    public void testConstantExpression() {
        this.assertExpression("Hello World", "Hello World");
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)this.context.resolveLanguage("simple").createExpression("${null}").evaluate(this.exchange, Object.class));
    }

    @Test
    public void testSimpleFileDir() {
        this.assertExpression("file:mydir", "file:mydir");
    }

    @Test
    public void testEmptyExpression() {
        this.assertExpression("", "");
        this.assertExpression(" ", " ");
        IllegalArgumentException e1 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertExpression(null, null), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"expression must be specified", (Object)e1.getMessage());
        this.assertPredicate("", false);
        this.assertPredicate(" ", false);
        IllegalArgumentException e2 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertPredicate(null, false), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"expression must be specified", (Object)e2.getMessage());
    }

    @Test
    public void testExchangeExpression() {
        Expression exp = this.context.resolveLanguage("simple").createExpression("${exchange}");
        Assertions.assertNotNull((Object)exp);
        Assertions.assertEquals((Object)this.exchange, (Object)exp.evaluate(this.exchange, Object.class));
        this.assertExpression("${exchange}", this.exchange);
    }

    @Test
    public void testLogExchangeExpression() {
        Expression exp = this.context.resolveLanguage("simple").createExpression("${logExchange}");
        Assertions.assertNotNull((Object)exp);
        ExchangeFormatter ef = LanguageHelper.getOrCreateExchangeFormatter((CamelContext)this.context, null);
        String expected = ef.format(this.exchange);
        Assertions.assertEquals((Object)expected, (Object)exp.evaluate(this.exchange, Object.class));
        this.assertExpression("${logExchange}", expected);
    }

    @Test
    public void testExchangeOgnlExpression() {
        Expression exp = this.context.resolveLanguage("simple").createExpression("${exchange.exchangeId}");
        Assertions.assertNotNull((Object)exp);
        Assertions.assertEquals((Object)this.exchange.getExchangeId(), (Object)exp.evaluate(this.exchange, Object.class));
        this.assertExpression("${exchange.exchangeId}", this.exchange.getExchangeId());
        this.assertExpression("${exchange.class.name}", "org.apache.camel.support.DefaultExchange");
    }

    @Test
    public void testBodyExpression() {
        Expression exp = this.context.resolveLanguage("simple").createExpression("${body}");
        Assertions.assertNotNull((Object)exp);
    }

    @Test
    public void testBodyOgnlExpression() {
        Expression exp = this.context.resolveLanguage("simple").createExpression("${body.xxx}");
        Assertions.assertNotNull((Object)exp);
        Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.context.resolveLanguage("simple").createExpression("${bodyxxx}"), (String)"Should throw exception");
    }

    @Test
    public void testBodyExpressionUsingAlternativeStartToken() {
        Expression exp = this.context.resolveLanguage("simple").createExpression("$simple{body}");
        Assertions.assertNotNull((Object)exp);
    }

    @Test
    public void testBodyExpressionNotStringType() {
        this.exchange.getIn().setBody((Object)123);
        Expression exp = this.context.resolveLanguage("simple").createExpression("${body}");
        Assertions.assertNotNull((Object)exp);
        Object val = exp.evaluate(this.exchange, Object.class);
        SimpleTest.assertIsInstanceOf(Integer.class, val);
        Assertions.assertEquals((Object)123, (Object)val);
    }

    @Test
    public void testBodyExpressionWithArray() {
        this.exchange.getIn().setBody((Object)new MyClass());
        Expression exp = this.context.resolveLanguage("simple").createExpression("${body.myArray}");
        Assertions.assertNotNull((Object)exp);
        Object val = exp.evaluate(this.exchange, Object.class);
        SimpleTest.assertIsInstanceOf(Object[].class, val);
        exp = this.context.resolveLanguage("simple").createExpression("${body.myArray.length}");
        Assertions.assertNotNull((Object)exp);
        val = exp.evaluate(this.exchange, Object.class);
        SimpleTest.assertIsInstanceOf(Integer.class, val);
        Assertions.assertEquals((Object)3, (Object)val);
    }

    @Test
    public void testSimpleExpressions() {
        this.assertExpression("${exchangeId}", this.exchange.getExchangeId());
        this.assertExpression("${id}", this.exchange.getIn().getMessageId());
        this.assertExpression("${body}", "<hello id='m123'>world!</hello>");
        this.assertExpression("${in.body}", "<hello id='m123'>world!</hello>");
        this.assertExpression("${in.header.foo}", "abc");
        this.assertExpression("${in.headers.foo}", "abc");
        this.assertExpression("${header.foo}", "abc");
        this.assertExpression("${headers.foo}", "abc");
        this.assertExpression("${routeId}", ExchangeHelper.getRouteId((Exchange)this.exchange));
        this.assertExpression("${fromRouteId}", this.exchange.getFromRouteId());
        this.exchange.getExchangeExtension().setFromRouteId("myRouteId");
        this.assertExpression("${routeId}", "myRouteId");
    }

    @Test
    public void testTrimSimpleExpressions() {
        this.assertExpression(" \t${exchangeId}\n".trim(), this.exchange.getExchangeId());
        this.assertExpression("\n${id}\r".trim(), this.exchange.getIn().getMessageId());
        this.assertExpression("\t\r ${body}".trim(), "<hello id='m123'>world!</hello>");
        this.assertExpression("\n${in.body}\r".trim(), "<hello id='m123'>world!</hello>");
    }

    @Test
    public void testSimpleThreadId() {
        long id = Thread.currentThread().getId();
        this.assertExpression("${threadId}", id);
        this.assertExpression("The id is ${threadId}", "The id is " + id);
    }

    @Test
    public void testSimpleThreadName() {
        String name = Thread.currentThread().getName();
        this.assertExpression("${threadName}", name);
        this.assertExpression("The name is ${threadName}", "The name is " + name);
    }

    @Test
    public void testSimpleHostname() {
        String name = InetAddressUtil.getLocalHostNameSafe();
        this.assertExpression("${hostname}", name);
        this.assertExpression("The host is ${hostname}", "The host is " + name);
    }

    @Test
    public void testSimpleStepId() {
        this.assertExpression("${stepId}", null);
        this.exchange.setProperty("CamelStepId", (Object)"foo");
        this.assertExpression("${stepId}", "foo");
    }

    @Test
    public void testSimpleExchangePropertyExpressions() {
        this.exchange.setProperty("medal", (Object)"gold");
        this.assertExpression("${exchangeProperty.medal}", "gold");
        this.assertExpression("${exchangeProperty:medal}", "gold");
    }

    @Test
    @ResourceLock(value="java.lang.System.properties")
    public void testSimpleSystemPropertyExpressions() {
        System.setProperty("who", "I was here");
        this.assertExpression("${sys.who}", "I was here");
    }

    @Test
    public void testSimpleSystemEnvironmentExpressions() {
        String path = System.getenv("PATH");
        if (path != null) {
            this.assertExpression("${sysenv.PATH}", path);
            this.assertExpression("${sysenv:PATH}", path);
            this.assertExpression("${env.PATH}", path);
            this.assertExpression("${env:PATH}", path);
        }
    }

    @Test
    public void testSimpleSystemEnvironmentExpressionsIfDash() {
        String foo = System.getenv("FOO_SERVICE_HOST");
        if (foo != null) {
            this.assertExpression("${sysenv.FOO-SERVICE-HOST}", foo);
            this.assertExpression("${sysenv:FOO-SERVICE-HOST}", foo);
            this.assertExpression("${env.FOO-SERVICE-HOST}", foo);
            this.assertExpression("${env:FOO-SERVICE-HOST}", foo);
        }
    }

    @Test
    public void testSimpleSystemEnvironmentExpressionsIfLowercase() {
        String path = System.getenv("PATH");
        if (path != null) {
            this.assertExpression("${sysenv.path}", path);
            this.assertExpression("${sysenv:path}", path);
            this.assertExpression("${env.path}", path);
            this.assertExpression("${env:path}", path);
        }
    }

    @Test
    public void testSimpleCamelId() {
        this.assertExpression("${camelId}", this.context.getName());
    }

    @Test
    public void testOGNLBodyListAndMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cool", "Camel rocks");
        map.put("dude", "Hey dude");
        map.put("code", 4321);
        ArrayList<HashMap<String, Object>> lines = new ArrayList<HashMap<String, Object>>();
        lines.add(map);
        this.exchange.getIn().setBody(lines);
        this.assertExpression("${in.body[0][cool]}", "Camel rocks");
        this.assertExpression("${body[0][cool]}", "Camel rocks");
        this.assertExpression("${in.body[0][code]}", 4321);
        this.assertExpression("${body[0][code]}", 4321);
    }

    @Test
    public void testOGNLBodyEmptyList() {
        HashMap map = new HashMap();
        map.put("list", new ArrayList());
        this.exchange.getIn().setBody(map);
        this.assertExpression("${in.body?.get('list')[0].toString}", null);
    }

    @Test
    public void testOGNLBodyExpression() {
        this.exchange.getIn().setBody((Object)"hello world");
        this.assertPredicate("${body} == 'hello world'", true);
        this.assertPredicate("${body.toUpperCase()} == 'HELLO WORLD'", true);
    }

    @Test
    public void testOGNLBodyAsExpression() {
        byte[] body = "hello world".getBytes();
        this.exchange.getIn().setBody((Object)body);
        RuntimeBeanExpressionException e = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertPredicate("${body.toUpperCase()} == 'HELLO WORLD'", true), (String)"Should throw exception");
        MethodNotFoundException cause = SimpleTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
        Assertions.assertEquals((Object)"toUpperCase()", (Object)cause.getMethodName());
        this.assertPredicate("${bodyAs(String)} == 'hello world'", true);
        this.assertPredicate("${bodyAs(String).toUpperCase()} == 'HELLO WORLD'", true);
        Assertions.assertSame((Object)body, (Object)this.exchange.getIn().getBody());
    }

    @Test
    public void testOGNLMandatoryBodyAsExpression() {
        byte[] body = "hello world".getBytes();
        this.exchange.getIn().setBody((Object)body);
        RuntimeBeanExpressionException e = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertPredicate("${body.toUpperCase()} == 'HELLO WORLD'", true), (String)"Should throw exception");
        MethodNotFoundException cause = SimpleTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
        Assertions.assertEquals((Object)"toUpperCase()", (Object)cause.getMethodName());
        this.assertPredicate("${mandatoryBodyAs(String)} == 'hello world'", true);
        this.assertPredicate("${mandatoryBodyAs(String).toUpperCase()} == 'HELLO WORLD'", true);
        Assertions.assertSame((Object)body, (Object)this.exchange.getIn().getBody());
    }

    @Test
    public void testOGNLCallReplace() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cool", "Camel rocks");
        map.put("dude", "Hey dude");
        this.exchange.getIn().setHeaders(map);
        this.assertExpression("${headers.cool.replaceAll(\"rocks\", \"is so cool\")}", "Camel is so cool");
    }

    @Test
    public void testOGNLBodyListAndMapAndMethod() {
        HashMap<String, OrderLine> map = new HashMap<String, OrderLine>();
        map.put("camel", new OrderLine(123, "Camel in Action"));
        map.put("amq", new OrderLine(456, "ActiveMQ in Action"));
        ArrayList<HashMap<String, OrderLine>> lines = new ArrayList<HashMap<String, OrderLine>>();
        lines.add(map);
        this.exchange.getIn().setBody(lines);
        this.assertExpression("${in.body[0][camel].id}", 123);
        this.assertExpression("${in.body[0][camel].name}", "Camel in Action");
        this.assertExpression("${in.body[0][camel].getId}", 123);
        this.assertExpression("${in.body[0][camel].getName}", "Camel in Action");
        this.assertExpression("${body[0][camel].id}", 123);
        this.assertExpression("${body[0][camel].name}", "Camel in Action");
        this.assertExpression("${body[0][camel].getId}", 123);
        this.assertExpression("${body[0][camel].getName}", "Camel in Action");
    }

    @Test
    public void testOGNLPropertyList() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Camel in Action");
        lines.add("ActiveMQ in Action");
        this.exchange.setProperty("wicket", lines);
        this.assertExpression("${exchangeProperty.wicket[0]}", "Camel in Action");
        this.assertExpression("${exchangeProperty.wicket[1]}", "ActiveMQ in Action");
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.assertExpression("${exchangeProperty.wicket[2]}", ""), (String)"Should have thrown an exception");
        IndexOutOfBoundsException cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
        Assertions.assertEquals((Object)INDEX_OUT_OF_BOUNDS_ERROR_MSG, (Object)cause.getMessage());
        this.assertExpression("${exchangeProperty.unknown[cool]}", null);
    }

    @Test
    public void testOGNLPropertyLinesList() {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        this.exchange.setProperty("wicket", lines);
        this.assertExpression("${exchangeProperty.wicket[0].getId}", 123);
        this.assertExpression("${exchangeProperty.wicket[1].getName}", "ActiveMQ in Action");
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.assertExpression("${exchangeProperty.wicket[2]}", ""), (String)"Should have thrown an exception");
        IndexOutOfBoundsException cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
        Assertions.assertEquals((Object)INDEX_OUT_OF_BOUNDS_ERROR_MSG, (Object)cause.getMessage());
        this.assertExpression("${exchangeProperty.unknown[cool]}", null);
    }

    @Test
    public void testOGNLPropertyMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cool", "Camel rocks");
        map.put("dude", "Hey dude");
        map.put("code", 4321);
        this.exchange.setProperty("wicket", map);
        this.assertExpression("${exchangeProperty.wicket[cool]}", "Camel rocks");
        this.assertExpression("${exchangeProperty.wicket[dude]}", "Hey dude");
        this.assertExpression("${exchangeProperty.wicket[unknown]}", null);
        this.assertExpression("${exchangeProperty.wicket[code]}", 4321);
        this.assertExpression("${exchangeProperty?.unknown[cool]}", null);
        this.assertExpression("${exchangeProperty.unknown[cool]}", null);
    }

    @Test
    public void testOGNLExchangePropertyMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cool", "Camel rocks");
        map.put("dude", "Hey dude");
        map.put("code", 4321);
        this.exchange.setProperty("wicket", map);
        this.assertExpression("${exchangeProperty.wicket[cool]}", "Camel rocks");
        this.assertExpression("${exchangeProperty.wicket[dude]}", "Hey dude");
        this.assertExpression("${exchangeProperty.wicket[unknown]}", null);
        this.assertExpression("${exchangeProperty.wicket[code]}", 4321);
        this.assertExpression("${exchangeProperty?.unknown[cool]}", null);
        this.assertExpression("${exchangeProperty.unknown[cool]}", null);
    }

    @Test
    public void testOGNLPropertyMapWithDot() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("this.code", "This code");
        this.exchange.setProperty("wicket", map);
        this.assertExpression("${exchangeProperty.wicket[this.code]}", "This code");
    }

    @Test
    public void testOGNLPropertyMapNotMap() {
        RuntimeBeanExpressionException e = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertExpression("${exchangeProperty.foobar[bar]}", null), (String)"Should have thrown an exception");
        IndexOutOfBoundsException cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
        Assertions.assertEquals((Object)"Key: bar not found in bean: cba of type: java.lang.String using OGNL path [[bar]]", (Object)cause.getMessage());
    }

    @Test
    public void testOGNLPropertyMapIllegalSyntax() {
        ExpressionIllegalSyntaxException e = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("${exchangeProperty.foobar[bar}", null), (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Valid syntax: ${exchangeProperty.OGNL} was: exchangeProperty.foobar[bar at location 0"));
    }

    @Test
    public void testOGNLExchangePropertyMapIllegalSyntax() {
        ExpressionIllegalSyntaxException e = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("${exchangeProperty.foobar[bar}", null), (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Valid syntax: ${exchangeProperty.OGNL} was: exchangeProperty.foobar[bar at location 0"));
    }

    @Test
    public void testOGNLHeaderEmptyTest() {
        this.exchange.getIn().setHeader("beer", (Object)"");
        this.assertPredicate("${header.beer} == ''", true);
        this.assertPredicate("${header.beer} == \"\"", true);
        this.assertPredicate("${header.beer} == ' '", false);
        this.assertPredicate("${header.beer} == \" \"", false);
        this.exchange.getIn().setHeader("beer", (Object)" ");
        this.assertPredicate("${header.beer} == ''", false);
        this.assertPredicate("${header.beer} == \"\"", false);
        this.assertPredicate("${header.beer} == ' '", true);
        this.assertPredicate("${header.beer} == \" \"", true);
        this.assertPredicate("${header.beer.toString().trim()} == ''", true);
        this.assertPredicate("${header.beer.toString().trim()} == \"\"", true);
        this.exchange.getIn().setHeader("beer", (Object)"   ");
        this.assertPredicate("${header.beer.trim()} == ''", true);
        this.assertPredicate("${header.beer.trim()} == \"\"", true);
    }

    @Test
    public void testDateExpressions() {
        Calendar inHeaderCalendar = Calendar.getInstance();
        inHeaderCalendar.set(1974, 3, 20);
        this.exchange.getIn().setHeader("birthday", (Object)inHeaderCalendar.getTime());
        Calendar propertyCalendar = Calendar.getInstance();
        propertyCalendar.set(1976, 5, 22);
        this.exchange.setProperty("birthday", (Object)propertyCalendar.getTime());
        this.assertExpression("${date:header.birthday}", inHeaderCalendar.getTime());
        this.assertExpression("${date:header.birthday:yyyyMMdd}", "19740420");
        this.assertExpression("${date:header.birthday+24h:yyyyMMdd}", "19740421");
        this.assertExpression("${date:exchangeProperty.birthday}", propertyCalendar.getTime().getTime());
        this.assertExpression("${date:exchangeProperty.birthday}", propertyCalendar.getTime());
        this.assertExpression("${date:exchangeProperty.birthday:yyyyMMdd}", "19760622");
        this.assertExpression("${date:exchangeProperty.birthday+24h:yyyyMMdd}", "19760623");
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertExpression("${date:yyyyMMdd}", "19740420"), (String)"Should thrown an exception");
        Assertions.assertEquals((Object)"Command not supported for dateExpression: yyyyMMdd", (Object)e.getMessage());
    }

    @Test
    public void testDateAndTimeExpressions() {
        Calendar cal = Calendar.getInstance();
        cal.set(1974, 3, 20, 8, 55, 47);
        cal.set(14, 123);
        this.exchange.getIn().setHeader("birthday", (Object)cal.getTime());
        this.assertExpression("${date:header.birthday - 10s:yyyy-MM-dd'T'HH:mm:ss:SSS}", "1974-04-20T08:55:37:123");
        this.assertExpression("${date:header.birthday:yyyy-MM-dd'T'HH:mm:ss:SSS}", "1974-04-20T08:55:47:123");
    }

    @Test
    public void testDateWithConverterExpressions() {
        this.exchange.getIn().setHeader("birthday", (Object)new MyCustomDate(1974, 3, 20));
        this.exchange.setProperty("birthday", (Object)new MyCustomDate(1974, 3, 20));
        this.exchange.getIn().setHeader("other", new ArrayList());
        this.assertExpression("${date:header.birthday:yyyyMMdd}", "19740420");
        this.assertExpression("${date:exchangeProperty.birthday:yyyyMMdd}", "19740420");
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertExpression("${date:header.other:yyyyMMdd}", "19740420"), (String)"Should thrown an exception");
        Assertions.assertEquals((Object)"Cannot find Date/long object at command: header.other", (Object)e.getMessage());
    }

    @Test
    public void testDateWithTimezone() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        cal.set(1974, 3, 20, 8, 55, 47);
        cal.set(14, 123);
        this.exchange.getIn().setHeader("birthday", (Object)cal.getTime());
        this.assertExpression("${date-with-timezone:header.birthday:GMT+8:yyyy-MM-dd'T'HH:mm:ss:SSS}", "1974-04-20T08:55:47:123");
        this.assertExpression("${date-with-timezone:header.birthday:GMT:yyyy-MM-dd'T'HH:mm:ss:SSS}", "1974-04-20T00:55:47:123");
    }

    @Test
    public void testDateNow() {
        Object out = this.evaluateExpression("${date:now:hh:mm:ss a}", null);
        Assertions.assertNotNull((Object)out);
    }

    @Test
    public void testDateExchangeCreated() {
        Object out = this.evaluateExpression("${date:exchangeCreated:hh:mm:ss a}", ("" + this.exchange.getClock().getCreated()).getClass());
        Assertions.assertNotNull((Object)out);
    }

    @Test
    public void testDatePredicates() {
        this.assertPredicate("${date:now} < ${date:now+60s}");
        this.assertPredicate("${date:now-5s} < ${date:now}");
        this.assertPredicate("${date:now+5s} > ${date:now}");
    }

    @Test
    public void testLanguagesInContext() {
        this.assertExpression("${id}", this.exchange.getIn().getMessageId());
        Assertions.assertEquals((int)1, (int)this.context.getLanguageNames().size());
        Assertions.assertEquals((Object)"simple", this.context.getLanguageNames().iterator().next());
    }

    @Test
    public void testComplexExpressions() {
        this.assertExpression("hey ${in.header.foo}", "hey abc");
        this.assertExpression("hey ${in.header:foo}", "hey abc");
        this.assertExpression("hey ${in.header.foo}!", "hey abc!");
        this.assertExpression("hey ${in.header:foo}!", "hey abc!");
        this.assertExpression("hey ${in.header.foo}-${in.header.foo}!", "hey abc-abc!");
        this.assertExpression("hey ${in.header:foo}-${in.header.foo}!", "hey abc-abc!");
        this.assertExpression("hey ${in.header.foo}${in.header.foo}", "hey abcabc");
        this.assertExpression("hey ${in.header:foo}${in.header.foo}", "hey abcabc");
        this.assertExpression("${in.header.foo}${in.header.foo}", "abcabc");
        this.assertExpression("${in.header:foo}${in.header:foo}", "abcabc");
        this.assertExpression("${in.header.foo}", "abc");
        this.assertExpression("${in.header:foo}", "abc");
        this.assertExpression("${in.header.foo}!", "abc!");
        this.assertExpression("${in.header:foo}!", "abc!");
    }

    @Test
    public void testComplexExpressionsUsingAlternativeStartToken() {
        this.assertExpression("hey $simple{in.header.foo}", "hey abc");
        this.assertExpression("hey $simple{in.header:foo}", "hey abc");
        this.assertExpression("hey $simple{in.header.foo}!", "hey abc!");
        this.assertExpression("hey $simple{in.header:foo}!", "hey abc!");
        this.assertExpression("hey $simple{in.header.foo}-$simple{in.header.foo}!", "hey abc-abc!");
        this.assertExpression("hey $simple{in.header:foo}-$simple{in.header.foo}!", "hey abc-abc!");
        this.assertExpression("hey $simple{in.header.foo}$simple{in.header.foo}", "hey abcabc");
        this.assertExpression("hey $simple{in.header:foo}$simple{in.header.foo}", "hey abcabc");
        this.assertExpression("$simple{in.header.foo}$simple{in.header.foo}", "abcabc");
        this.assertExpression("$simple{in.header:foo}$simple{in.header.foo}", "abcabc");
        this.assertExpression("$simple{in.header.foo}", "abc");
        this.assertExpression("$simple{in.header:foo}", "abc");
        this.assertExpression("$simple{in.header.foo}!", "abc!");
        this.assertExpression("$simple{in.header:foo}!", "abc!");
    }

    @Test
    public void testInvalidComplexExpression() {
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertExpression("hey ${foo", "bad expression!"), (String)"Should have thrown an exception!");
        Assertions.assertEquals((int)8, (int)e.getIndex());
    }

    @Test
    public void testPredicates() {
        this.assertPredicate("${body}");
        this.assertPredicate("${header.foo}");
        this.assertPredicate("${header.madeUpHeader}", false);
    }

    @Test
    public void testExceptionMessage() {
        this.exchange.setException((Throwable)new IllegalArgumentException("Just testing"));
        this.assertExpression("${exception.message}", "Just testing");
        this.assertExpression("Hello ${exception.message} World", "Hello Just testing World");
    }

    @Test
    public void testExceptionStacktrace() {
        this.exchange.setException((Throwable)new IllegalArgumentException("Just testing"));
        String out = (String)this.context.resolveLanguage("simple").createExpression("${exception.stacktrace}").evaluate(this.exchange, String.class);
        Assertions.assertNotNull((Object)out);
        Assertions.assertTrue((boolean)out.startsWith("java.lang.IllegalArgumentException: Just testing"));
        Assertions.assertTrue((boolean)out.contains("at org.apache.camel.language."));
    }

    @Test
    public void testException() {
        this.exchange.setException((Throwable)new IllegalArgumentException("Just testing"));
        Exception out = (Exception)this.context.resolveLanguage("simple").createExpression("${exception}").evaluate(this.exchange, Exception.class);
        Assertions.assertNotNull((Object)out);
        SimpleTest.assertIsInstanceOf(IllegalArgumentException.class, out);
        Assertions.assertEquals((Object)"Just testing", (Object)out.getMessage());
    }

    @Test
    public void testMessageAs() {
        this.assertPredicate("${messageAs(org.apache.camel.language.simple.MyAttachmentMessage).hasAttachments}", false);
        this.assertPredicate("${messageAs(org.apache.camel.language.simple.MyAttachmentMessage)?.hasAttachments}", false);
        MyAttachmentMessage msg = new MyAttachmentMessage(this.exchange);
        msg.setBody("<hello id='m123'>world!</hello>");
        this.exchange.setMessage((Message)msg);
        this.assertPredicate("${messageAs(org.apache.camel.language.simple.MyAttachmentMessage).hasAttachments}", true);
        this.assertPredicate("${messageAs(org.apache.camel.language.simple.MyAttachmentMessage)?.hasAttachments}", true);
        this.assertExpression("${messageAs(org.apache.camel.language.simple.MyAttachmentMessage).size}", "42");
    }

    @Test
    public void testBodyAs() {
        this.assertExpression("${bodyAs(String)}", "<hello id='m123'>world!</hello>");
        this.assertExpression("${bodyAs('String')}", "<hello id='m123'>world!</hello>");
        this.exchange.getIn().setBody(null);
        this.assertExpression("${bodyAs('String')}", null);
        this.exchange.getIn().setBody((Object)456);
        this.assertExpression("${bodyAs(Integer)}", 456);
        this.assertExpression("${bodyAs(int)}", 456);
        this.assertExpression("${bodyAs('int')}", 456);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.assertExpression("${bodyAs(XXX)}", 456), (String)"Should have thrown an exception");
        SimpleTest.assertIsInstanceOf(ClassNotFoundException.class, e.getCause());
    }

    @Test
    public void testMandatoryBodyAs() {
        this.assertExpression("${mandatoryBodyAs(String)}", "<hello id='m123'>world!</hello>");
        this.assertExpression("${mandatoryBodyAs('String')}", "<hello id='m123'>world!</hello>");
        this.exchange.getIn().setBody(null);
        CamelExecutionException e1 = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.assertExpression("${mandatoryBodyAs('String')}", ""), (String)"Should have thrown exception");
        SimpleTest.assertIsInstanceOf(InvalidPayloadException.class, e1.getCause());
        this.exchange.getIn().setBody((Object)456);
        this.assertExpression("${mandatoryBodyAs(Integer)}", 456);
        this.assertExpression("${mandatoryBodyAs(int)}", 456);
        this.assertExpression("${mandatoryBodyAs('int')}", 456);
        CamelExecutionException e2 = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.assertExpression("${mandatoryBodyAs(XXX)}", 456), (String)"Should have thrown an exception");
        SimpleTest.assertIsInstanceOf(ClassNotFoundException.class, e2.getCause());
    }

    @Test
    public void testHeaderEmptyBody() {
        this.exchange.getIn().setBody(null);
        this.assertExpression("${header.foo}", "abc");
        this.assertExpression("${header:foo}", "abc");
        this.assertExpression("${headers.foo}", "abc");
        this.assertExpression("${headers:foo}", "abc");
        this.assertExpression("${in.header.foo}", "abc");
        this.assertExpression("${in.header:foo}", "abc");
        this.assertExpression("${in.headers.foo}", "abc");
        this.assertExpression("${in.headers:foo}", "abc");
    }

    @Test
    public void testHeadersWithBracket() {
        this.assertExpression("${headers[foo]}", "abc");
        this.assertExpression("${in.headers[foo]}", "abc");
    }

    @Test
    public void testOnglOnHeadersWithBracket() {
        this.assertOnglOnHeadersWithSquareBrackets("order");
        this.assertOnglOnHeadersWithSquareBrackets("purchase.order");
        this.assertOnglOnHeadersWithSquareBrackets("foo.bar.qux");
        this.assertOnglOnHeadersWithSquareBrackets("purchase order");
    }

    private void assertOnglOnHeadersWithSquareBrackets(String key) {
        this.exchange.getIn().setHeader(key, (Object)new OrderLine(123, "Camel in Action"));
        this.assertExpression("${headers[" + key + "].name}", "Camel in Action");
        this.assertExpression("${in.headers[" + key + "].name}", "Camel in Action");
        this.assertExpression("${in.headers['" + key + "'].name}", "Camel in Action");
    }

    @Test
    public void testOnglOnExchangePropertiesWithBracket() throws Exception {
        this.assertOnglOnExchangePropertiesWithBracket("order");
        this.assertOnglOnExchangePropertiesWithBracket("purchase.order");
        this.assertOnglOnExchangePropertiesWithBracket("foo.bar.qux");
        this.assertOnglOnExchangePropertiesWithBracket("purchase order");
    }

    public void assertOnglOnExchangePropertiesWithBracket(String key) {
        this.exchange.setProperty(key, (Object)new OrderLine(123, "Camel in Action"));
        this.assertExpression("${exchangeProperty[" + key + "].name}", "Camel in Action");
        this.assertExpression("${exchangeProperty['" + key + "'].name}", "Camel in Action");
    }

    @Test
    public void testIsInstanceOfEmptyBody() {
        this.exchange.getIn().setBody(null);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertPredicate("${body} is null", false), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)11, (int)e.getIndex());
    }

    @Test
    public void testHeaders() {
        Map headers = this.exchange.getIn().getHeaders();
        Assertions.assertEquals((int)2, (int)headers.size());
        this.assertExpression("${headers}", headers);
        this.assertExpression("${in.headers}", headers);
        this.assertExpression("${headers.size}", 2);
    }

    @Test
    public void testHeaderKeyWithSpace() {
        Map headers = this.exchange.getIn().getHeaders();
        headers.put("some key", "Some Value");
        Assertions.assertEquals((int)3, (int)headers.size());
        this.assertExpression("${headerAs(foo,String)}", "abc");
        this.assertExpression("${headerAs(some key,String)}", "Some Value");
        this.assertExpression("${headerAs('some key',String)}", "Some Value");
        this.assertExpression("${header[foo]}", "abc");
        this.assertExpression("${header[some key]}", "Some Value");
        this.assertExpression("${header['some key']}", "Some Value");
        this.assertExpression("${headers[foo]}", "abc");
        this.assertExpression("${headers[some key]}", "Some Value");
        this.assertExpression("${headers['some key']}", "Some Value");
    }

    @Test
    public void testHeaderAs() {
        this.assertExpression("${headerAs(foo,String)}", "abc");
        this.assertExpression("${headerAs(bar,int)}", 123);
        this.assertExpression("${headerAs(bar, int)}", 123);
        this.assertExpression("${headerAs('bar', int)}", 123);
        this.assertExpression("${headerAs('bar','int')}", 123);
        this.assertExpression("${headerAs('bar','Integer')}", 123);
        this.assertExpression("${headerAs('bar',\"int\")}", 123);
        this.assertExpression("${headerAs(bar,String)}", "123");
        this.assertExpression("${headerAs(unknown,String)}", null);
        ExpressionIllegalSyntaxException e1 = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("${headerAs(unknown String)}", null), (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e1.getMessage().startsWith("Valid syntax: ${headerAs(key, type)} was: headerAs(unknown String)"));
        ExpressionIllegalSyntaxException e2 = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("${headerAs(fool,String).test}", null), (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e2.getMessage().startsWith("Valid syntax: ${headerAs(key, type)} was: headerAs(fool,String).test"));
        CamelExecutionException e3 = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.assertExpression("${headerAs(bar,XXX)}", 123), (String)"Should have thrown an exception");
        SimpleTest.assertIsInstanceOf(ClassNotFoundException.class, e3.getCause());
    }

    @Test
    public void testVariables() {
        this.exchange.getVariables().putAll(this.exchange.getMessage().getHeaders());
        this.exchange.getMessage().removeHeaders("*");
        Map variables = this.exchange.getVariables();
        Assertions.assertEquals((int)3, (int)variables.size());
        this.assertExpression("${variables}", variables);
        this.assertExpression("${variables.size}", 3);
    }

    @Test
    public void testGlobalVariable() {
        Map variables = this.exchange.getVariables();
        Assertions.assertEquals((int)1, (int)variables.size());
        VariableRepository global = ((VariableRepositoryFactory)this.context.getCamelContextExtension().getContextPlugin(VariableRepositoryFactory.class)).getVariableRepository("global");
        global.setVariable("foo", (Object)"123");
        global.setVariable("bar", (Object)"456");
        global.setVariable("cheese", (Object)"gorgonzola");
        this.assertExpression("${variable.cheese}", "gauda");
        this.assertExpression("${variable.foo}", null);
        this.assertExpression("${variable.bar}", null);
        this.assertExpression("${variable.global:cheese}", "gorgonzola");
        this.assertExpression("${variable.global:foo}", "123");
        this.assertExpression("${variable.global:bar}", "456");
        this.assertExpression("${variableAs('cheese', 'String')}", "gauda");
        this.assertExpression("${variableAs('foo', 'int')}", null);
        this.assertExpression("${variableAA('bar', 'int')}", null);
        this.assertExpression("${variableAs('global:cheese', 'String')}", "gorgonzola");
        this.assertExpression("${variableAs('global:foo', 'int')}", 123);
        this.assertExpression("${variableAs('global:bar', 'int')}", 456);
    }

    @Test
    public void testVariableKeyWithSpace() {
        this.exchange.getVariables().putAll(this.exchange.getMessage().getHeaders());
        this.exchange.getMessage().removeHeaders("*");
        Map variables = this.exchange.getVariables();
        variables.put("some key", "Some Value");
        Assertions.assertEquals((int)4, (int)variables.size());
        this.assertExpression("${variableAs(foo,String)}", "abc");
        this.assertExpression("${variableAs(some key,String)}", "Some Value");
        this.assertExpression("${variableAs('some key',String)}", "Some Value");
        this.assertExpression("${variable[foo]}", "abc");
        this.assertExpression("${variable[cheese]}", "gauda");
        this.assertExpression("${variable[some key]}", "Some Value");
        this.assertExpression("${variable['some key']}", "Some Value");
        this.assertExpression("${variables[foo]}", "abc");
        this.assertExpression("${variables[cheese]}", "gauda");
        this.assertExpression("${variables[some key]}", "Some Value");
        this.assertExpression("${variables['some key']}", "Some Value");
    }

    @Test
    public void testVariableAs() {
        this.exchange.getVariables().putAll(this.exchange.getMessage().getHeaders());
        this.exchange.getMessage().removeHeaders("*");
        this.assertExpression("${variableAs(foo,String)}", "abc");
        this.assertExpression("${variableAs(bar,int)}", 123);
        this.assertExpression("${variableAs(bar, int)}", 123);
        this.assertExpression("${variableAs('bar', int)}", 123);
        this.assertExpression("${variableAs('bar','int')}", 123);
        this.assertExpression("${variableAs('bar','Integer')}", 123);
        this.assertExpression("${variableAs('bar',\"int\")}", 123);
        this.assertExpression("${variableAs(bar,String)}", "123");
        this.assertExpression("${variableAs(unknown,String)}", null);
        ExpressionIllegalSyntaxException e1 = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("${variableAs(unknown String)}", null), (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e1.getMessage().startsWith("Valid syntax: ${variableAs(key, type)} was: variableAs(unknown String)"));
        ExpressionIllegalSyntaxException e2 = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("${variableAs(fool,String).test}", null), (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e2.getMessage().startsWith("Valid syntax: ${variableAs(key, type)} was: variableAs(fool,String).test"));
        CamelExecutionException e3 = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.assertExpression("${variableAs(bar,XXX)}", 123), (String)"Should have thrown an exception");
        SimpleTest.assertIsInstanceOf(ClassNotFoundException.class, e3.getCause());
    }

    @Test
    public void testIllegalSyntax() {
        ExpressionIllegalSyntaxException e1 = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("hey ${xxx} how are you?", ""), (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e1.getMessage().startsWith("Unknown function: xxx at location 4"));
        ExpressionIllegalSyntaxException e2 = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("${xxx}", ""), (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e2.getMessage().startsWith("Unknown function: xxx at location 0"));
        ExpressionIllegalSyntaxException e3 = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("${bodyAs(xxx}", ""), (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e3.getMessage().startsWith("Valid syntax: ${bodyAs(type)} was: bodyAs(xxx"));
    }

    @Test
    public void testOGNLHeaderList() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Camel in Action");
        lines.add("ActiveMQ in Action");
        this.exchange.getIn().setHeader("wicket", lines);
        this.assertExpression("${header.wicket[0]}", "Camel in Action");
        this.assertExpression("${header.wicket[1]}", "ActiveMQ in Action");
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.assertExpression("${header.wicket[2]}", ""), (String)"Should have thrown an exception");
        IndexOutOfBoundsException cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
        Assertions.assertEquals((Object)INDEX_OUT_OF_BOUNDS_ERROR_MSG, (Object)cause.getMessage());
        this.assertExpression("${header.unknown[cool]}", null);
    }

    @Test
    public void testOGNLHeaderLinesList() {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        this.exchange.getIn().setHeader("wicket", lines);
        this.assertExpression("${header.wicket[0].getId}", 123);
        this.assertExpression("${header.wicket[1].getName}", "ActiveMQ in Action");
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.assertExpression("${header.wicket[2]}", ""), (String)"Should have thrown an exception");
        IndexOutOfBoundsException cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
        Assertions.assertEquals((Object)INDEX_OUT_OF_BOUNDS_ERROR_MSG, (Object)cause.getMessage());
        this.assertExpression("${header.unknown[cool]}", null);
    }

    @Test
    public void testOGNLHeaderMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cool", "Camel rocks");
        map.put("dude", "Hey dude");
        map.put("code", 4321);
        this.exchange.getIn().setHeader("wicket", map);
        this.assertExpression("${header.wicket[cool]}", "Camel rocks");
        this.assertExpression("${header.wicket[dude]}", "Hey dude");
        this.assertExpression("${header.wicket[unknown]}", null);
        this.assertExpression("${header.wicket[code]}", 4321);
        this.assertExpression("${header?.unknown[cool]}", null);
        this.assertExpression("${header.unknown[cool]}", null);
    }

    @Test
    public void testOGNLHeaderMapWithDot() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("this.code", "This code");
        this.exchange.getIn().setHeader("wicket", map);
        this.assertExpression("${header.wicket[this.code]}", "This code");
    }

    @Test
    public void testOGNLHeaderMapNotMap() {
        RuntimeBeanExpressionException e = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertExpression("${header.foo[bar]}", null), (String)"Should have thrown an exception");
        IndexOutOfBoundsException cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
        Assertions.assertEquals((Object)"Key: bar not found in bean: abc of type: java.lang.String using OGNL path [[bar]]", (Object)cause.getMessage());
    }

    @Test
    public void testOGNLHeaderMapIllegalSyntax() {
        ExpressionIllegalSyntaxException e = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("${header.foo[bar}", null), (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Valid syntax: ${header.name[key]} was: header.foo[bar"));
    }

    @Test
    public void testBodyOGNLAsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", "Camel");
        map.put("bar", 6);
        this.exchange.getIn().setBody(map);
        this.assertExpression("${in.body[foo]}", "Camel");
        this.assertExpression("${in.body[bar]}", 6);
    }

    @Test
    public void testBodyOGNLAsMapWithDot() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo.bar", "Camel");
        this.exchange.getIn().setBody(map);
        this.assertExpression("${in.body[foo.bar]}", "Camel");
    }

    @Test
    public void testBodyOGNLAsMapShorthand() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", "Camel");
        map.put("bar", 6);
        this.exchange.getIn().setBody(map);
        this.assertExpression("${body[foo]}", "Camel");
        this.assertExpression("${body[bar]}", 6);
    }

    @Test
    public void testBodyOGNLSimple() {
        Animal camel = new Animal("Camel", 6);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${in.body.getName}", "Camel");
        this.assertExpression("${in.body.getAge}", 6);
    }

    @Test
    public void testExceptionOGNLSimple() {
        this.exchange.getIn().setHeader("CamelAuthenticationFailurePolicyId", (Object)"myPolicy");
        this.exchange.setProperty("CamelExceptionCaught", (Object)new CamelAuthorizationException("The camel authorization exception", this.exchange));
        this.assertExpression("${exception.getPolicyId}", "myPolicy");
    }

    @Test
    public void testBodyOGNLSimpleShorthand() {
        Animal camel = new Animal("Camel", 6);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${in.body.name}", "Camel");
        this.assertExpression("${in.body.age}", 6);
    }

    @Test
    public void testBodyOGNLSimpleOperator() {
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal camel = new Animal("Camel", 6);
        camel.setFriend(tiger);
        this.exchange.getIn().setBody((Object)camel);
        this.assertPredicate("${in.body.getName} contains 'Camel'", true);
        this.assertPredicate("${in.body.getName} contains 'Tiger'", false);
        this.assertPredicate("${in.body.getAge} < 10", true);
        this.assertPredicate("${in.body.getAge} > 10", false);
        this.assertPredicate("${in.body.getAge} <= '6'", true);
        this.assertPredicate("${in.body.getAge} > '6'", false);
        this.assertPredicate("${in.body.getAge} < ${body.getFriend.getAge}", true);
        this.assertPredicate("${in.body.getFriend.isDangerous} == true", true);
    }

    @Test
    public void testBodyOGNLSimpleOperatorShorthand() {
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal camel = new Animal("Camel", 6);
        camel.setFriend(tiger);
        this.exchange.getIn().setBody((Object)camel);
        this.assertPredicate("${in.body.name} contains 'Camel'", true);
        this.assertPredicate("${in.body.name} contains 'Tiger'", false);
        this.assertPredicate("${in.body.age} < 10", true);
        this.assertPredicate("${in.body.age} > 10", false);
        this.assertPredicate("${in.body.age} <= '6'", true);
        this.assertPredicate("${in.body.age} > '6'", false);
        this.assertPredicate("${in.body.age} < ${body.friend.age}", true);
        this.assertPredicate("${in.body.friend.dangerous} == true", true);
    }

    @Test
    public void testBodyOGNLNested() {
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal camel = new Animal("Camel", 6);
        camel.setFriend(tiger);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${in.body.getName}", "Camel");
        this.assertExpression("${in.body.getAge}", 6);
        this.assertExpression("${in.body.getFriend.getName}", "Tony the Tiger");
        this.assertExpression("${in.body.getFriend.getAge}", "13");
    }

    @Test
    public void testBodyOGNLNestedShorthand() {
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal camel = new Animal("Camel", 6);
        camel.setFriend(tiger);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${in.body.name}", "Camel");
        this.assertExpression("${in.body.age}", 6);
        this.assertExpression("${in.body.friend.name}", "Tony the Tiger");
        this.assertExpression("${in.body.friend.age}", "13");
    }

    @Test
    public void testBodyOGNLOrderList() {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        this.assertExpression("${in.body.getLines[0].getId}", 123);
        this.assertExpression("${in.body.getLines[0].getName}", "Camel in Action");
        this.assertExpression("${in.body.getLines[1].getId}", 456);
        this.assertExpression("${in.body.getLines[1].getName}", "ActiveMQ in Action");
        this.assertExpression("${in.body.getLines[last].getId}", 456);
        this.assertExpression("${in.body.getLines[last].getName}", "ActiveMQ in Action");
        this.assertExpression("${in.body.getLines[last-1].getId}", 123);
        this.assertExpression("${in.body.getLines[last-1].getName}", "Camel in Action");
    }

    @Test
    public void testBodyOGNLOrderListShorthand() {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        this.assertExpression("${in.body.lines[0].id}", 123);
        this.assertExpression("${in.body.lines[0].name}", "Camel in Action");
        this.assertExpression("${in.body.lines[1].id}", 456);
        this.assertExpression("${in.body.lines[1].name}", "ActiveMQ in Action");
        this.assertExpression("${in.body.lines[last].id}", 456);
        this.assertExpression("${in.body.lines[last].name}", "ActiveMQ in Action");
        this.assertExpression("${in.body.lines[last-1].id}", 123);
        this.assertExpression("${in.body.lines[last-1].name}", "Camel in Action");
        this.assertExpression("${in.body.lines.size}", 2);
    }

    @Test
    public void testBodyOGNLListMap() {
        ArrayList grid = new ArrayList();
        LinkedHashMap<String, String> cells = new LinkedHashMap<String, String>();
        cells.put("ABC", "123");
        cells.put("DEF", "456");
        grid.add(cells);
        LinkedHashMap<String, String> cells2 = new LinkedHashMap<String, String>();
        cells2.put("HIJ", "789");
        grid.add(cells2);
        this.exchange.getIn().setBody(grid);
        this.assertExpression("${in.body[0][ABC]}", "123");
        this.assertExpression("${in.body[0][DEF]}", "456");
        this.assertExpression("${in.body[0]['ABC']}", "123");
        this.assertExpression("${in.body[0]['DEF']}", "456");
        this.assertExpression("${in.body[1][HIJ]}", "789");
        this.assertExpression("${in.body[1]['HIJ']}", "789");
    }

    @Test
    public void testBodyOGNLList() {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        this.exchange.getIn().setBody(lines);
        this.assertExpression("${in.body[0].getId}", 123);
        this.assertExpression("${in.body[0].getName}", "Camel in Action");
        this.assertExpression("${in.body[1].getId}", 456);
        this.assertExpression("${in.body[1].getName}", "ActiveMQ in Action");
    }

    @Test
    public void testBodyOGNLListShorthand() {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        this.exchange.getIn().setBody(lines);
        this.assertExpression("${in.body[0].id}", 123);
        this.assertExpression("${in.body[0].name}", "Camel in Action");
        this.assertExpression("${in.body[1].id}", 456);
        this.assertExpression("${in.body[1].name}", "ActiveMQ in Action");
    }

    @Test
    public void testBodyOGNLArray() {
        OrderLine[] lines = new OrderLine[]{new OrderLine(123, "Camel in Action"), new OrderLine(456, "ActiveMQ in Action")};
        this.exchange.getIn().setBody((Object)lines);
        this.assertExpression("${in.body[0].getId}", 123);
        this.assertExpression("${in.body[0].getName}", "Camel in Action");
        this.assertExpression("${in.body[1].getId}", 456);
        this.assertExpression("${in.body[1].getName}", "ActiveMQ in Action");
    }

    @Test
    public void testBodyOGNLArrayShorthand() {
        OrderLine[] lines = new OrderLine[]{new OrderLine(123, "Camel in Action"), new OrderLine(456, "ActiveMQ in Action")};
        this.exchange.getIn().setBody((Object)lines);
        this.assertExpression("${in.body[0].id}", 123);
        this.assertExpression("${in.body[0].name}", "Camel in Action");
        this.assertExpression("${in.body[1].id}", 456);
        this.assertExpression("${in.body[1].name}", "ActiveMQ in Action");
    }

    @Test
    public void testBodyOGNLOrderListOutOfBounds() {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        RuntimeBeanExpressionException e1 = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertExpression("${in.body.getLines[3].getId}", 123), (String)"Should have thrown an exception");
        IndexOutOfBoundsException cause1 = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e1.getCause());
        Assertions.assertTrue((boolean)cause1.getMessage().startsWith("Index: 3, Size: 2 out of bounds with List from bean"));
        RuntimeBeanExpressionException e2 = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertExpression("${in.body.getLines[last-2].getId}", 123), (String)"Should have thrown an exception");
        IndexOutOfBoundsException cause2 = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e2.getCause());
        Assertions.assertTrue((boolean)cause2.getMessage().startsWith("Index: -1, Size: 2 out of bounds with List from bean"));
        RuntimeBeanExpressionException e3 = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertExpression("${in.body.getLines[last - XXX].getId}", 123), (String)"Should have thrown an exception");
        ExpressionIllegalSyntaxException cause3 = SimpleTest.assertIsInstanceOf(ExpressionIllegalSyntaxException.class, e3.getCause());
        Assertions.assertEquals((Object)"last - XXX", (Object)cause3.getExpression());
    }

    @Test
    public void testBodyOGNLOrderListOutOfBoundsShorthand() {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        RuntimeBeanExpressionException e1 = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertExpression("${in.body.lines[3].id}", 123), (String)"Should have thrown an exception");
        IndexOutOfBoundsException cause1 = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e1.getCause());
        Assertions.assertTrue((boolean)cause1.getMessage().startsWith("Index: 3, Size: 2 out of bounds with List from bean"));
        RuntimeBeanExpressionException e2 = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertExpression("${in.body.lines[last - 2].id}", 123), (String)"Should have thrown an exception");
        IndexOutOfBoundsException cause2 = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e2.getCause());
        Assertions.assertTrue((boolean)cause2.getMessage().startsWith("Index: -1, Size: 2 out of bounds with List from bean"));
        RuntimeBeanExpressionException e3 = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertExpression("${in.body.lines[last - XXX].id}", 123), (String)"Should have thrown an exception");
        ExpressionIllegalSyntaxException cause3 = SimpleTest.assertIsInstanceOf(ExpressionIllegalSyntaxException.class, e3.getCause());
        Assertions.assertEquals((Object)"last - XXX", (Object)cause3.getExpression());
    }

    @Test
    public void testBodyOGNLOrderListOutOfBoundsWithNullSafe() {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        this.assertExpression("${in.body?.getLines[3].getId}", null);
    }

    @Test
    public void testBodyOGNLOrderListOutOfBoundsWithNullSafeShorthand() {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        this.assertExpression("${in.body?.lines[3].id}", null);
    }

    @Test
    public void testBodyOGNLOrderListNoMethodNameWithNullSafe() {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        RuntimeBeanExpressionException e = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertExpression("${in.body.getLines[0]?.getRating}", ""), (String)"Should have thrown exception");
        MethodNotFoundException cause = SimpleTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
        Assertions.assertEquals((Object)"getRating", (Object)cause.getMethodName());
    }

    @Test
    public void testBodyOGNLOrderListNoMethodNameWithNullSafeShorthand() {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        RuntimeBeanExpressionException e = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertExpression("${in.body.lines[0]?.rating}", ""), (String)"Should have thrown exception");
        MethodNotFoundException cause = SimpleTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
        Assertions.assertEquals((Object)"rating", (Object)cause.getMethodName());
    }

    @Test
    public void testBodyOGNLNullSafeToAvoidNPE() {
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal camel = new Animal("Camel", 6);
        camel.setFriend(tiger);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${in.body.getName}", "Camel");
        this.assertExpression("${in.body.getAge}", 6);
        this.assertExpression("${in.body.getFriend.getName}", "Tony the Tiger");
        this.assertExpression("${in.body.getFriend.getAge}", "13");
        this.assertExpression("${in.body.getFriend?.getFriend.getName}", null);
        RuntimeBeanExpressionException e = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertExpression("${in.body.getFriend.getFriend.getName}", ""), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"Failed to invoke method: .getFriend.getFriend.getName on org.apache.camel.language.simple.SimpleTest.Animal due last method returned null and therefore cannot continue to invoke method .getName on a null instance", (Object)e.getMessage());
    }

    @Test
    public void testBodyOGNLNullSafeToAvoidNPEShorthand() {
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal camel = new Animal("Camel", 6);
        camel.setFriend(tiger);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${in.body.name}", "Camel");
        this.assertExpression("${in.body.age}", 6);
        this.assertExpression("${in.body.friend.getName}", "Tony the Tiger");
        this.assertExpression("${in.body.getFriend.age}", "13");
        this.assertExpression("${in.body.friend?.friend.name}", null);
        RuntimeBeanExpressionException e = (RuntimeBeanExpressionException)Assertions.assertThrows(RuntimeBeanExpressionException.class, () -> this.assertExpression("${in.body.friend.friend.name}", ""), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"Failed to invoke method: .friend.friend.name on org.apache.camel.language.simple.SimpleTest.Animal due last method returned null and therefore cannot continue to invoke method .name on a null instance", (Object)e.getMessage());
    }

    @Test
    public void testBodyOGNLReentrant() {
        Animal camel = new Animal("Camel", 6);
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal elephant = new Animal("Big Ella", 48);
        camel.setFriend(tiger);
        tiger.setFriend(elephant);
        elephant.setFriend(camel);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${body.getFriend.getFriend.getFriend.getName}", "Camel");
        this.assertExpression("${body.getFriend.getFriend.getFriend.getFriend.getName}", "Tony the Tiger");
        this.assertExpression("${body.getFriend.getFriend.getFriend.getFriend.getFriend.getName}", "Big Ella");
    }

    @Test
    public void testBodyOGNLReentrantShorthand() {
        Animal camel = new Animal("Camel", 6);
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal elephant = new Animal("Big Ella", 48);
        camel.setFriend(tiger);
        tiger.setFriend(elephant);
        elephant.setFriend(camel);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${body.friend.friend.friend.name}", "Camel");
        this.assertExpression("${body.friend.friend.friend.friend.name}", "Tony the Tiger");
        this.assertExpression("${body.friend.friend.friend.friend.friend.name}", "Big Ella");
    }

    @Test
    public void testBodyOGNLBoolean() {
        Animal tiger = new Animal("Tony the Tiger", 13);
        this.exchange.getIn().setBody((Object)tiger);
        this.assertExpression("${body.isDangerous}", "true");
        this.assertExpression("${body.dangerous}", "true");
        Animal camel = new Animal("Camel", 6);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${body.isDangerous}", "false");
        this.assertExpression("${body.dangerous}", "false");
    }

    @Test
    public void testBodyOgnlOnString() {
        this.exchange.getIn().setBody((Object)"Camel");
        this.assertExpression("${body.substring(2)}", "mel");
        this.assertExpression("${body.substring(2, 4)}", "me");
        this.assertExpression("${body.length()}", 5);
        this.assertExpression("${body.toUpperCase()}", "CAMEL");
        this.assertExpression("${body.toUpperCase()}", "CAMEL");
        this.assertExpression("${body.toUpperCase().substring(2)}", "MEL");
        this.assertExpression("${body.toLowerCase().length()}", 5);
    }

    @Test
    public void testBodyOgnlOnStringWithOgnlParams() {
        this.exchange.getIn().setBody((Object)"Camel");
        this.exchange.getIn().setHeader("max", (Object)4);
        this.exchange.getIn().setHeader("min", (Object)2);
        this.assertExpression("${body.substring(${header.min}, ${header.max})}", "me");
    }

    @Test
    public void testHeaderOgnlOnStringWithOgnlParams() {
        this.exchange.getIn().setBody(null);
        this.exchange.getIn().setHeader("name", (Object)"Camel");
        this.exchange.getIn().setHeader("max", (Object)4);
        this.exchange.getIn().setHeader("min", (Object)2);
        this.assertExpression("${header.name.substring(${header.min}, ${header.max})}", "me");
    }

    @Test
    public void testCamelContextStartRoute() {
        this.exchange.getIn().setBody(null);
        this.assertExpression("${camelContext.getRouteController().startRoute('foo')}", null);
    }

    @Test
    public void testBodyOgnlReplace() {
        this.exchange.getIn().setBody((Object)"Kamel is a cool Kamel");
        this.assertExpression("${body.replace(\"Kamel\", \"Camel\")}", "Camel is a cool Camel");
    }

    @Test
    public void testBodyOgnlReplaceEscapedChar() {
        this.exchange.getIn().setBody((Object)"foo$bar$baz");
        this.assertExpression("${body.replace('$', '-')}", "foo-bar-baz");
    }

    @Test
    public void testBodyOgnlReplaceEscapedBackslashChar() {
        this.exchange.getIn().setBody((Object)"foo\\bar\\baz");
        this.assertExpression("${body.replace('\\', '\\\\')}", "foo\\\\bar\\\\baz");
    }

    @Test
    public void testBodyOgnlReplaceFirst() {
        this.exchange.getIn().setBody((Object)"http:camel.apache.org");
        this.assertExpression("${body.replaceFirst('http:', 'https:')}", "https:camel.apache.org");
        this.assertExpression("${body.replaceFirst('http:', '')}", "camel.apache.org");
        this.assertExpression("${body.replaceFirst('http:', ' ')}", " camel.apache.org");
        this.assertExpression("${body.replaceFirst('http:',    ' ')}", " camel.apache.org");
        this.assertExpression("${body.replaceFirst('http:',' ')}", " camel.apache.org");
    }

    @Test
    public void testBodyOgnlReplaceSingleQuoteInDouble() {
        this.exchange.getIn().setBody((Object)"Hello O'Conner");
        this.assertExpression("${body.replace(\"O'C\", \"OC\")}", "Hello OConner");
        this.assertExpression("${body.replace(\"O'C\", \"O C\")}", "Hello O Conner");
        this.assertExpression("${body.replace(\"O'C\", \"O-C\")}", "Hello O-Conner");
        this.assertExpression("${body.replace(\"O'C\", \"O''C\")}", "Hello O''Conner");
        this.assertExpression("${body.replace(\"O'C\", \"O\n'C\")}", "Hello O\n'Conner");
    }

    @Test
    public void testBodyOgnlSpaces() {
        this.exchange.getIn().setBody((Object)"Hello World");
        this.assertExpression("${body.compareTo(Hello World)}", 0);
        this.assertExpression("${body.compareTo('Hello World')}", 0);
        this.assertExpression("${body.compareTo(${body})}", 0);
        this.assertExpression("${body.compareTo('foo')}", "Hello World".compareTo("foo"));
        this.assertExpression("${body.compareTo( 'Hello World' )}", 0);
        this.assertExpression("${body.compareTo( ${body} )}", 0);
        this.assertExpression("${body.compareTo( 'foo' )}", "Hello World".compareTo("foo"));
    }

    @Test
    public void testClassSimpleName() {
        Animal tiger = new Animal("Tony the Tiger", 13);
        this.exchange.getIn().setBody((Object)tiger);
        this.assertExpression("${body.getClass().getSimpleName()}", "Animal");
        this.assertExpression("${body.getClass.getSimpleName}", "Animal");
        this.assertExpression("${body.class.simpleName}", "Animal");
    }

    @Test
    public void testExceptionClassSimpleName() {
        Animal tiger = new Animal("Tony the Tiger", 13);
        this.exchange.getIn().setBody((Object)tiger);
        IllegalArgumentException cause = new IllegalArgumentException("Forced");
        this.exchange.setException((Throwable)cause);
        this.assertExpression("${exception.getClass().getSimpleName()}", "IllegalArgumentException");
        this.assertExpression("${exception.getClass.getSimpleName}", "IllegalArgumentException");
        this.assertExpression("${exception.class.simpleName}", "IllegalArgumentException");
    }

    @Test
    public void testSlashBeforeHeader() {
        this.assertExpression("foo/${header.foo}", "foo/abc");
        this.assertExpression("foo\\${header.foo}", "foo\\abc");
    }

    @Test
    public void testJSonLike() {
        this.exchange.getIn().setBody((Object)"Something");
        this.assertExpression("{\n\"data\": \"${body}\"\n}", "{\n\"data\": \"Something\"\n}");
    }

    @Test
    public void testFunctionEnds() {
        this.exchange.getIn().setBody((Object)"Something");
        this.assertExpression("{{", "{{");
        this.assertExpression("}}", "}}");
        this.assertExpression("{{}}", "{{}}");
        this.assertExpression("{{foo}}", "{{foo}}");
        this.assertExpression("{{${body}}}", "{{Something}}");
        this.assertExpression("{{${body}-${body}}}", "{{Something-Something}}");
    }

    @Test
    public void testEscape() {
        this.exchange.getIn().setBody((Object)"Something");
        this.assertExpression("\\foo", "\\foo");
        this.assertExpression("\\n${body}", "\nSomething");
        this.assertExpression("\\t${body}", "\tSomething");
        this.assertExpression("\\r${body}", "\rSomething");
        this.assertExpression("\\n\\r${body}", "\n\rSomething");
        this.assertExpression("\\n${body}\\n", "\nSomething\n");
        this.assertExpression("\\t${body}\\t", "\tSomething\t");
        this.assertExpression("\\r${body}\\r", "\rSomething\r");
        this.assertExpression("\\n\\r${body}\\n\\r", "\n\rSomething\n\r");
        this.assertExpression("$${body}", "$Something");
    }

    @Test
    public void testEscapeEndFunction() {
        this.exchange.getIn().setBody((Object)"Something");
        this.assertExpression("{hello\\}", "{hello}");
        this.assertExpression("${body}{hello\\}", "Something{hello}");
    }

    @Test
    public void testCamelContextOGNL() {
        this.assertExpression("${camelContext.getName()}", this.context.getName());
        this.assertExpression("${camelContext.version}", this.context.getVersion());
    }

    @Test
    public void testTypeConstant() {
        this.assertExpression("${type:org.apache.camel.Exchange.FILE_NAME}", "CamelFileName");
        this.assertExpression("${type:org.apache.camel.ExchangePattern.InOut}", ExchangePattern.InOut);
        Exception e1 = (Exception)Assertions.assertThrows(Exception.class, () -> this.assertExpression("${type:org.apache.camel.ExchangePattern.}", null), (String)"Should throw exception");
        SimpleTest.assertIsInstanceOf(ClassNotFoundException.class, e1.getCause());
        Exception e2 = (Exception)Assertions.assertThrows(Exception.class, () -> this.assertExpression("${type:org.apache.camel.ExchangePattern.UNKNOWN}", null), (String)"Should throw exception");
        SimpleTest.assertIsInstanceOf(ClassNotFoundException.class, e2.getCause());
    }

    @Test
    public void testTypeConstantInnerClass() {
        this.assertExpression("${type:org.apache.camel.language.simple.Constants$MyInnerStuff.FOO}", 123);
        this.assertExpression("${type:org.apache.camel.language.simple.Constants.BAR}", 456);
    }

    @Test
    public void testStringArrayLength() {
        this.exchange.getIn().setBody((Object)new String[]{"foo", "bar"});
        this.assertExpression("${body[0]}", "foo");
        this.assertExpression("${body[1]}", "bar");
        this.assertExpression("${body.length}", 2);
        this.exchange.getIn().setBody((Object)new String[]{"foo", "bar", "beer"});
        this.assertExpression("${body.length}", 3);
    }

    @Test
    public void testByteArrayLength() {
        this.exchange.getIn().setBody((Object)new byte[]{65, 66, 67});
        this.assertExpression("${body[0]}", 65);
        this.assertExpression("${body[1]}", 66);
        this.assertExpression("${body[2]}", 67);
        this.assertExpression("${body.length}", 3);
    }

    @Test
    public void testIntArrayLength() {
        this.exchange.getIn().setBody((Object)new int[]{1, 20, 300});
        this.assertExpression("${body[0]}", 1);
        this.assertExpression("${body[1]}", 20);
        this.assertExpression("${body[2]}", 300);
        this.assertExpression("${body.length}", 3);
    }

    @Test
    public void testSimpleMapBoolean() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        this.exchange.getIn().setBody(map);
        map.put("isCredit", true);
        this.assertPredicate("${body[isCredit]} == true", true);
        this.assertPredicate("${body[isCredit]} == false", false);
        this.assertPredicate("${body['isCredit']} == true", true);
        this.assertPredicate("${body['isCredit']} == false", false);
        this.assertPredicate("${body['IsCredit']} == true", false);
        map.put("isCredit", false);
        this.assertPredicate("${body[isCredit]} == true", false);
        this.assertPredicate("${body[isCredit]} == false", true);
        this.assertPredicate("${body['isCredit']} == true", false);
        this.assertPredicate("${body['isCredit']} == false", true);
    }

    @Test
    public void testSimpleRegexp() {
        this.exchange.getIn().setBody((Object)"12345678");
        this.assertPredicate("${body} regex '\\d+'", true);
        this.assertPredicate("${body} regex '\\w{1,4}'", false);
        this.exchange.getIn().setBody((Object)"tel:+97444549697");
        this.assertPredicate("${body} regex '^(tel:\\+)(974)(44)(\\d+)|^(974)(44)(\\d+)'", true);
        this.exchange.getIn().setBody((Object)"97444549697");
        this.assertPredicate("${body} regex '^(tel:\\+)(974)(44)(\\d+)|^(974)(44)(\\d+)'", true);
        this.exchange.getIn().setBody((Object)"tel:+87444549697");
        this.assertPredicate("${body} regex '^(tel:\\+)(974)(44)(\\d+)|^(974)(44)(\\d+)'", false);
        this.exchange.getIn().setBody((Object)"87444549697");
        this.assertPredicate("${body} regex '^(tel:\\+)(974)(44)(\\d+)|^(974)(44)(\\d+)'", false);
    }

    @Test
    public void testCollateEven() {
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        data.add("C");
        data.add("D");
        data.add("E");
        data.add("F");
        this.exchange.getIn().setBody(data);
        Iterator it = (Iterator)this.evaluateExpression("${collate(3)}", null);
        List chunk = (List)it.next();
        List chunk2 = (List)it.next();
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertEquals((int)3, (int)chunk.size());
        Assertions.assertEquals((int)3, (int)chunk2.size());
        Assertions.assertEquals((Object)"A", chunk.get(0));
        Assertions.assertEquals((Object)"B", chunk.get(1));
        Assertions.assertEquals((Object)"C", chunk.get(2));
        Assertions.assertEquals((Object)"D", chunk2.get(0));
        Assertions.assertEquals((Object)"E", chunk2.get(1));
        Assertions.assertEquals((Object)"F", chunk2.get(2));
    }

    @Test
    public void testCollateOdd() {
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        data.add("C");
        data.add("D");
        data.add("E");
        data.add("F");
        data.add("G");
        this.exchange.getIn().setBody(data);
        Iterator it = (Iterator)this.evaluateExpression("${collate(3)}", null);
        List chunk = (List)it.next();
        List chunk2 = (List)it.next();
        List chunk3 = (List)it.next();
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertEquals((int)3, (int)chunk.size());
        Assertions.assertEquals((int)3, (int)chunk2.size());
        Assertions.assertEquals((int)1, (int)chunk3.size());
        Assertions.assertEquals((Object)"A", chunk.get(0));
        Assertions.assertEquals((Object)"B", chunk.get(1));
        Assertions.assertEquals((Object)"C", chunk.get(2));
        Assertions.assertEquals((Object)"D", chunk2.get(0));
        Assertions.assertEquals((Object)"E", chunk2.get(1));
        Assertions.assertEquals((Object)"F", chunk2.get(2));
        Assertions.assertEquals((Object)"G", chunk3.get(0));
    }

    @Test
    public void testJoinBody() {
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        data.add("C");
        this.exchange.getIn().setBody(data);
        this.assertExpression("${join()}", "A,B,C");
        this.assertExpression("${join(;)}", "A;B;C");
        this.assertExpression("${join(' ')}", "A B C");
        this.assertExpression("${join(',','id=')}", "id=A,id=B,id=C");
        this.assertExpression("${join(&,id=)}", "id=A&id=B&id=C");
    }

    @Test
    public void testJoinHeader() {
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        data.add("C");
        this.exchange.getIn().setHeader("id", data);
        this.assertExpression("${join('&','id=','${header.id}')}", "id=A&id=B&id=C");
    }

    @Test
    public void testRandomExpression() {
        Expression expression;
        int min = 1;
        int max = 10;
        int iterations = 30;
        int i = 0;
        for (i = 0; i < iterations; ++i) {
            expression = this.context.resolveLanguage("simple").createExpression("${random(1,10)}");
            Assertions.assertTrue((min <= (Integer)expression.evaluate(this.exchange, Integer.class) && (Integer)expression.evaluate(this.exchange, Integer.class) < max ? 1 : 0) != 0);
        }
        for (i = 0; i < iterations; ++i) {
            expression = this.context.resolveLanguage("simple").createExpression("${random(10)}");
            Assertions.assertTrue((0 <= (Integer)expression.evaluate(this.exchange, Integer.class) && (Integer)expression.evaluate(this.exchange, Integer.class) < max ? 1 : 0) != 0);
        }
        expression = this.context.resolveLanguage("simple").createExpression("${random(1, 10)}");
        Assertions.assertTrue((min <= (Integer)expression.evaluate(this.exchange, Integer.class) && (Integer)expression.evaluate(this.exchange, Integer.class) < max ? 1 : 0) != 0);
        Expression expression1 = this.context.resolveLanguage("simple").createExpression("${random( 10)}");
        Assertions.assertTrue((0 <= (Integer)expression1.evaluate(this.exchange, Integer.class) && (Integer)expression1.evaluate(this.exchange, Integer.class) < max ? 1 : 0) != 0);
        Exception e1 = (Exception)Assertions.assertThrows(Exception.class, () -> this.assertExpression("${random(10,21,30)}", null), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"Valid syntax: ${random(min,max)} or ${random(max)} was: random(10,21,30)", (Object)e1.getCause().getMessage());
        Exception e2 = (Exception)Assertions.assertThrows(Exception.class, () -> this.assertExpression("${random()}", null), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"Valid syntax: ${random(min,max)} or ${random(max)} was: random()", (Object)e2.getCause().getMessage());
        this.exchange.getIn().setHeader("max", (Object)20);
        Expression expression3 = this.context.resolveLanguage("simple").createExpression("${random(10,${header.max})}");
        int num = (Integer)expression3.evaluate(this.exchange, Integer.class);
        Assertions.assertTrue((num >= 0 && num < 20 ? 1 : 0) != 0, (String)"Should be 10..20");
    }

    @Test
    public void testReplaceAllExpression() {
        this.exchange.getMessage().setBody((Object)"Hello a how are you");
        this.assertExpression("${replace(a,b)}", "Hello b how bre you");
        this.exchange.getMessage().setBody((Object)"{\"foo\": \"cheese\"}");
        this.assertExpression("${replace(&quot;,&apos;)}", "{'foo': 'cheese'}");
        this.exchange.getMessage().setBody((Object)"{'foo': 'cheese'}");
        this.assertExpression("${replace(&apos;,&quot;)}", "{\"foo\": \"cheese\"}");
        this.exchange.getMessage().setBody((Object)"{\"foo\": \"cheese\"}");
        this.assertExpression("${replace(&quot;,&empty;)}", "{foo: cheese}");
        this.exchange.getMessage().setBody((Object)"Hello");
        this.exchange.getMessage().setHeader("foo", (Object)"{\"foo\": \"cheese\"}");
        this.assertExpression("${replace(&quot;,&apos;,${header.foo})}", "{'foo': 'cheese'}");
    }

    @Test
    public void testSubstringExpression() {
        this.exchange.getMessage().setBody((Object)"ABCDEFGHIJK");
        this.assertExpression("${substring(0)}", "ABCDEFGHIJK");
        this.assertExpression("${substring(1)}", "BCDEFGHIJK");
        this.assertExpression("${substring(3)}", "DEFGHIJK");
        this.assertExpression("${substring(99)}", "");
        this.assertExpression("${substring(0)}", "ABCDEFGHIJK");
        this.assertExpression("${substring(-1)}", "ABCDEFGHIJ");
        this.assertExpression("${substring(-3)}", "ABCDEFGH");
        this.assertExpression("${substring(-99)}", "");
        this.assertExpression("${substring(1,-1)}", "BCDEFGHIJ");
        this.assertExpression("${substring(3,-3)}", "DEFGH");
        this.assertExpression("${substring(1,-3)}", "BCDEFGH");
        this.assertExpression("${substring(3,-1)}", "DEFGHIJ");
        this.assertExpression("${substring(0,-1)}", "ABCDEFGHIJ");
        this.assertExpression("${substring(1,0)}", "BCDEFGHIJK");
        this.assertExpression("${substring(99,-99)}", "");
        this.assertExpression("${substring(0,-99)}", "");
        this.assertExpression("${substring(99,0)}", "");
        this.assertExpression("${substring(0,0)}", "ABCDEFGHIJK");
        this.exchange.getMessage().setBody((Object)"Hello World");
        this.exchange.getMessage().setHeader("foo", (Object)"1234567890");
        this.assertExpression("${substring(0,0,${header.foo})}", "1234567890");
        this.assertExpression("${substring(1,0,${header.foo})}", "234567890");
        this.assertExpression("${substring(3,0,${header.foo})}", "4567890");
        this.assertExpression("${substring(99,0,${header.foo})}", "");
        this.assertExpression("${substring(0,0,${header.foo})}", "1234567890");
        this.assertExpression("${substring(0,-1,${header.foo})}", "123456789");
        this.assertExpression("${substring(0,-3,${header.foo})}", "1234567");
        this.assertExpression("${substring(0,-99,${header.foo})}", "");
        this.assertExpression("${substring(1,-1,${header.foo})}", "23456789");
        this.assertExpression("${substring(3,-3,${header.foo})}", "4567");
        this.assertExpression("${substring(1,-3,${header.foo})}", "234567");
        this.assertExpression("${substring(3,-1,${header.foo})}", "456789");
        this.assertExpression("${substring(0,-1,${header.foo})}", "123456789");
        this.assertExpression("${substring(1,0,${header.foo})}", "234567890");
        this.assertExpression("${substring(99,-99,${header.foo})}", "");
        this.assertExpression("${substring(0,-99,${header.foo})}", "");
        this.assertExpression("${substring(99,0,${header.foo})}", "");
        this.assertExpression("${substring(0,0,${header.foo})}", "1234567890");
    }

    @Test
    public void testIif() {
        this.exchange.getIn().setHeader("foo", (Object)44);
        this.assertExpression("${iif(${header.foo} > 0,'positive','negative')}", "positive");
        this.exchange.getIn().setHeader("foo", (Object)-123);
        this.assertExpression("${iif(${header.foo} > 0,'positive','negative')}", "negative");
        this.exchange.getIn().setBody((Object)"Hello World");
        this.exchange.getIn().setHeader("foo", (Object)44);
        this.assertExpression("${iif(${header.foo} > 0,${body},'Bye World')}", "Hello World");
        this.exchange.getIn().setHeader("foo", (Object)-123);
        this.assertExpression("${iif(${header.foo} > 0,${body},'Bye World')}", "Bye World");
        this.assertExpression("${iif(${header.foo} > 0,${body},${null})}", null);
    }

    @Test
    public void testListRemoveByInstance() {
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        this.exchange.getIn().setBody(data);
        Assertions.assertEquals((int)2, (int)data.size());
        Expression expression = this.context.resolveLanguage("simple").createExpression("${body.remove('A')}");
        expression.evaluate(this.exchange, Object.class);
        Assertions.assertEquals((int)1, (int)data.size());
        Assertions.assertEquals((Object)"B", data.get(0));
    }

    @Test
    public void testListRemoveIndex() {
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        this.exchange.getIn().setBody(data);
        Assertions.assertEquals((int)2, (int)data.size());
        Expression expression = this.context.resolveLanguage("simple").createExpression("${body.remove(0)}");
        expression.evaluate(this.exchange, Object.class);
        Assertions.assertEquals((int)1, (int)data.size());
        Assertions.assertEquals((Object)"B", data.get(0));
    }

    @Test
    public void testBodyOgnlOnAnimalWithOgnlParams() {
        this.exchange.getIn().setBody((Object)new Animal("tiger", 13));
        this.exchange.getIn().setHeader("friend", (Object)new Animal("donkey", 4));
        this.assertExpression("${body.setFriend(${header.friend})}", null);
        Animal animal = (Animal)this.exchange.getIn().getBody(Animal.class);
        Assertions.assertEquals((Object)"tiger", (Object)animal.getName());
        Assertions.assertEquals((int)13, (int)animal.getAge());
        Assertions.assertNotNull((Object)animal.getFriend(), (String)"Should have a friend");
        Assertions.assertEquals((Object)"donkey", (Object)animal.getFriend().getName());
        Assertions.assertEquals((int)4, (int)animal.getFriend().getAge());
    }

    @Test
    public void testBodyAsOneLine() {
        this.exchange.getIn().setBody((Object)("Hello" + System.lineSeparator() + "Great" + System.lineSeparator() + "World"));
        this.assertExpression("${bodyOneLine}", "HelloGreatWorld");
        this.assertExpression("Hi ${bodyOneLine}", "Hi HelloGreatWorld");
        this.assertExpression("Hi ${bodyOneLine} Again", "Hi HelloGreatWorld Again");
    }

    @Test
    public void testJsonPrettyPrint() {
        StringBuilder expectedJson = new StringBuilder();
        expectedJson.append("{");
        expectedJson.append("\n");
        expectedJson.append("\t\"firstName\": \"foo\",");
        expectedJson.append("\n");
        expectedJson.append("\t\"lastName\": \"bar\"");
        expectedJson.append("\n");
        expectedJson.append("}");
        expectedJson.append("\n");
        this.exchange.getIn().setBody((Object)"{\"firstName\": \"foo\", \"lastName\": \"bar\"}");
        this.assertExpression("${prettyBody}", expectedJson.toString());
        this.assertExpression("Hi ${prettyBody}", "Hi " + String.valueOf(expectedJson));
        this.assertExpression("Hi ${prettyBody} Again", "Hi " + String.valueOf(expectedJson) + " Again");
        expectedJson = new StringBuilder();
        expectedJson.append("[");
        expectedJson.append("\n");
        expectedJson.append("\t{");
        expectedJson.append("\n");
        expectedJson.append("\t\t\"firstName\": \"foo\",");
        expectedJson.append("\n");
        expectedJson.append("\t\t\"lastName\": \"bar\"");
        expectedJson.append("\n");
        expectedJson.append("\t},");
        expectedJson.append("\n");
        expectedJson.append("\t{");
        expectedJson.append("\n");
        expectedJson.append("\t\t\"firstName\": \"foo\",");
        expectedJson.append("\n");
        expectedJson.append("\t\t\"lastName\": \"bar\"");
        expectedJson.append("\n");
        expectedJson.append("\t}");
        expectedJson.append("\n");
        expectedJson.append("]");
        expectedJson.append("\n");
        this.exchange.getIn().setBody((Object)"[{\"firstName\": \"foo\", \"lastName\": \"bar\"},{\"firstName\": \"foo\", \"lastName\": \"bar\"}]");
        this.assertExpression("${prettyBody}", expectedJson.toString());
        this.assertExpression("Hi ${prettyBody}", "Hi " + String.valueOf(expectedJson));
        this.assertExpression("Hi ${prettyBody} Again", "Hi " + String.valueOf(expectedJson) + " Again");
    }

    @Test
    public void testXMLPrettyPrint() {
        StringBuilder expectedXml = new StringBuilder();
        expectedXml.append("<person>");
        expectedXml.append("\n");
        expectedXml.append("  <firstName>");
        expectedXml.append("\n");
        expectedXml.append("    foo");
        expectedXml.append("\n");
        expectedXml.append("  </firstName>");
        expectedXml.append("\n");
        expectedXml.append("  <lastName>");
        expectedXml.append("\n");
        expectedXml.append("    bar");
        expectedXml.append("\n");
        expectedXml.append("  </lastName>");
        expectedXml.append("\n");
        expectedXml.append("</person>");
        this.exchange.getIn().setBody((Object)"<person><firstName>foo</firstName><lastName>bar</lastName></person>");
        this.assertExpression("${prettyBody}", expectedXml.toString());
        this.assertExpression("Hi ${prettyBody}", "Hi " + String.valueOf(expectedXml));
        this.assertExpression("Hi ${prettyBody} Again", "Hi " + String.valueOf(expectedXml) + " Again");
    }

    @Test
    public void testNestedTypeFunction() {
        this.exchange.setProperty("CamelAuthentication", (Object)123);
        String exp = "${exchangeProperty.${type:org.apache.camel.Exchange.AUTHENTICATION}.toString()}";
        this.assertExpression(exp, "123");
        this.exchange.getIn().setHeader("whichOne", (Object)"AUTHENTICATION");
        this.exchange.setProperty("CamelAuthentication", (Object)456);
        exp = "${exchangeProperty.${type:org.apache.camel.Exchange.${header.whichOne}}.toString()}";
        this.assertExpression(exp, "456");
    }

    @Test
    public void testListIndexByNestedFunction() {
        ArrayList<String> alist = new ArrayList<String>();
        alist.add("1");
        alist.add("99");
        this.exchange.getIn().setHeader("ITEMS", alist);
        this.exchange.getIn().setHeader("TOTAL_LOOPS", (Object)alist.size());
        String exp = "${header.ITEMS[${exchangeProperty.CamelLoopIndex}]}";
        this.exchange.setProperty("CamelLoopIndex", (Object)0);
        this.assertExpression(exp, "1");
        this.exchange.setProperty("CamelLoopIndex", (Object)1);
        this.assertExpression(exp, "99");
    }

    @Test
    public void testMessageTimestamp() {
        this.exchange.getIn().setHeader("CamelMessageTimestamp", (Object)1234L);
        this.assertExpression("${messageTimestamp}", 1234L);
    }

    @Test
    public void testParenthesisReplaceAll() {
        this.exchange.getIn().setBody((Object)"Bik (Ru)");
        this.assertExpression("${body.replaceAll(\"Bik \\(Ru\\)\",\"bik_ru\").replaceAll(\"b\",\"c\")}", "cik_ru");
    }

    @Test
    public void testParenthesisReplace() {
        this.exchange.getIn().setBody((Object)"Hello (( World (((( Again");
        this.assertExpression("${body.replace(\"((\", \"--\").replace(\"((((\", \"----\")}", "Hello -- World ---- Again");
    }

    @Test
    public void testPropertiesExist() {
        PropertiesComponent pc = this.context.getPropertiesComponent();
        this.assertExpression("${propertiesExist:myKey}", "false");
        this.assertExpression("${propertiesExist:!myKey}", "true");
        this.assertPredicate("${propertiesExist:myKey}", false);
        this.assertPredicate("${propertiesExist:!myKey}", true);
        pc.addInitialProperty("myKey", "abc");
        this.assertExpression("${propertiesExist:myKey}", "true");
        this.assertExpression("${propertiesExist:!myKey}", "false");
        this.assertPredicate("${propertiesExist:myKey}", true);
        this.assertPredicate("${propertiesExist:!myKey}", false);
    }

    @Test
    public void testUuid() {
        Expression expression = this.context.resolveLanguage("simple").createExpression("${uuid}");
        String s = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertNotNull((Object)s);
        expression = this.context.resolveLanguage("simple").createExpression("${uuid(default)}");
        s = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertNotNull((Object)s);
        expression = this.context.resolveLanguage("simple").createExpression("${uuid(short)}");
        s = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertNotNull((Object)s);
        expression = this.context.resolveLanguage("simple").createExpression("${uuid(simple)}");
        s = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertNotNull((Object)s);
        expression = this.context.resolveLanguage("simple").createExpression("${uuid(classic)}");
        s = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertNotNull((Object)s);
        this.context.getRegistry().bind("mygen", () -> "1234");
        this.assertExpression("${uuid(mygen)}", "1234");
    }

    @Test
    public void testHash() throws Exception {
        Expression expression = this.context.resolveLanguage("simple").createExpression("${hash(hello)}");
        String s = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertNotNull((Object)s);
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] bytes = digest.digest("hello".getBytes(StandardCharsets.UTF_8));
        String expected = StringHelper.bytesToHex((byte[])bytes);
        Assertions.assertEquals((Object)expected, (Object)s);
        expression = this.context.resolveLanguage("simple").createExpression("${hash(${body})}");
        s = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertNotNull((Object)s);
        digest = MessageDigest.getInstance("SHA-256");
        bytes = digest.digest(((String)this.exchange.getMessage().getBody(String.class)).getBytes(StandardCharsets.UTF_8));
        expected = StringHelper.bytesToHex((byte[])bytes);
        Assertions.assertEquals((Object)expected, (Object)s);
        expression = this.context.resolveLanguage("simple").createExpression("${hash(${header.foo})}");
        s = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertNotNull((Object)s);
        expression = this.context.resolveLanguage("simple").createExpression("${hash(hello,SHA3-256)}");
        s = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertNotNull((Object)s);
        expression = this.context.resolveLanguage("simple").createExpression("${hash(${body},SHA3-256)}");
        s = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertNotNull((Object)s);
        digest = MessageDigest.getInstance("SHA3-256");
        bytes = digest.digest(((String)this.exchange.getMessage().getBody(String.class)).getBytes(StandardCharsets.UTF_8));
        expected = StringHelper.bytesToHex((byte[])bytes);
        Assertions.assertEquals((Object)expected, (Object)s);
        expression = this.context.resolveLanguage("simple").createExpression("${hash(${header.foo},SHA3-256)}");
        s = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertNotNull((Object)s);
        expression = this.context.resolveLanguage("simple").createExpression("${hash(${header.unknown})}");
        s = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void testNewEmpty() {
        this.assertExpressionCreateNewEmpty("list", List.class, v -> ((List)v).isEmpty());
        this.assertExpressionCreateNewEmpty("LIST", List.class, v -> ((List)v).isEmpty());
        this.assertExpressionCreateNewEmpty("List", List.class, v -> ((List)v).isEmpty());
        this.assertExpressionCreateNewEmpty("map", Map.class, v -> ((Map)v).isEmpty());
        this.assertExpressionCreateNewEmpty("MAP", Map.class, v -> ((Map)v).isEmpty());
        this.assertExpressionCreateNewEmpty("Map", Map.class, v -> ((Map)v).isEmpty());
        this.assertExpressionCreateNewEmpty("string", String.class, v -> ((String)v).isEmpty());
        this.assertExpressionCreateNewEmpty("STRING", String.class, v -> ((String)v).isEmpty());
        this.assertExpressionCreateNewEmpty("String", String.class, v -> ((String)v).isEmpty());
        Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.evaluateExpression("${empty(falseSyntax}", null));
        Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.evaluateExpression("${empty()}", null));
        Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.evaluateExpression("${empty(}", null));
        Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.evaluateExpression("${empty}", null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.evaluateExpression("${empty(unknownType)}", null));
    }

    @Test
    public void testPretty() {
        this.assertExpression(this.exchange, "${pretty('Hello')}", (Object)"Hello");
        this.assertExpression(this.exchange, "${pretty(${body})}", (Object)"<hello id=\"m123\">\n</hello>");
        this.exchange.getMessage().setBody((Object)"{\"name\": \"Jack\", \"id\": 123}");
        this.assertExpression(this.exchange, "${pretty(${body})}", (Object)"{\n\t\"name\": \"Jack\",\n\t\"id\": 123\n}\n");
    }

    private void assertExpressionCreateNewEmpty(String type, Class<?> expectedClass, java.util.function.Predicate<Object> isEmptyAssertion) {
        Object value = this.evaluateExpression("${empty(%s)}".formatted(type), null);
        Assertions.assertNotNull((Object)value);
        SimpleTest.assertIsInstanceOf(expectedClass, value);
        Assertions.assertTrue((boolean)isEmptyAssertion.test(value));
    }

    @Override
    protected String getLanguageName() {
        return "simple";
    }

    protected void assertExpressionResultInstanceOf(String expressionText, Class<?> expectedType) {
        Language language = this.assertResolveLanguage(this.getLanguageName());
        Expression expression = language.createExpression(expressionText);
        Assertions.assertNotNull(expectedType, (String)"Cannot assert type when no type is provided");
        Assertions.assertNotNull((Object)expression, (String)("No Expression could be created for text: " + expressionText + " language: " + String.valueOf(language)));
        Object answer = expression.evaluate(this.exchange, Object.class);
        SimpleTest.assertIsInstanceOf(expectedType, answer);
    }

    public static final class Animal {
        private final String name;
        private final int age;
        private Animal friend;

        private Animal(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        public Animal getFriend() {
            return this.friend;
        }

        public void setFriend(Animal friend) {
            this.friend = friend;
        }

        public boolean isDangerous() {
            return this.name.contains("Tiger");
        }

        public String toString() {
            return this.name;
        }
    }

    public static class MyClass {
        public Object[] getMyArray() {
            return new Object[]{"Hallo", "World", "!"};
        }
    }

    public static final class OrderLine {
        private final int id;
        private final String name;

        public OrderLine(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }

    public static final class Order {
        private List<OrderLine> lines;

        public Order(List<OrderLine> lines) {
            this.lines = lines;
        }

        public List<OrderLine> getLines() {
            return this.lines;
        }

        public void setLines(List<OrderLine> lines) {
            this.lines = lines;
        }
    }
}

