/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class SimpleSetHeaderPredicateTest
extends ContextTestSupport {
    @Test
    public void testSetHeaderPredicateFalse() throws Exception {
        this.getMockEndpoint("mock:result").expectedHeaderReceived("bar", (Object)false);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSetHeaderPredicateTrue() throws Exception {
        this.getMockEndpoint("mock:result").expectedHeaderReceived("bar", (Object)true);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOther() throws Exception {
        this.getMockEndpoint("mock:other").expectedHeaderReceived("param1", (Object)"hello");
        this.getMockEndpoint("mock:other").expectedHeaderReceived("param2", (Object)true);
        this.template.sendBody("direct:other", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setHeader("bar").simple("${header.foo} == 'Camel'", Boolean.TYPE)).to("mock:result");
                ((RouteDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:other").setHeader("param1", (Expression)this.constant("hello"))).log("param1 = ${header.param1}")).setHeader("param2").simple("${header.param1} == 'hello'", Boolean.class)).log("param2 = ${header.param2}")).to("mock:other");
            }
        };
    }
}

