/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.junit.jupiter.api.Test;

public class SimpleRouteExpressionAsPredicateTest
extends ContextTestSupport {
    @Test
    public void testSimpleRouteExpressionAsPredicateTest() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{true});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"ABC == ABC"});
        this.template.sendBodyAndHeader("direct:foo", (Object)"Hello World", "foo", (Object)"ABC");
        this.template.sendBodyAndHeader("direct:bar", (Object)"Hello World", "bar", (Object)"ABC");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:foo").setBody().simple("${header.foo} == ${header.foo}", Boolean.TYPE)).to("mock:foo");
                ((ProcessorDefinition)this.from("direct:bar").setBody().simple("${header.bar} == ${header.bar}")).to("mock:bar");
            }
        };
    }
}

