/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.List;
import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.language.simple.SimplePredicateParser;
import org.apache.camel.language.simple.ast.BinaryExpression;
import org.apache.camel.language.simple.ast.LiteralNode;
import org.apache.camel.language.simple.ast.SimpleFunctionStart;
import org.apache.camel.language.simple.ast.SingleQuoteStart;
import org.apache.camel.language.simple.types.BinaryOperatorType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimplePredicateParserNodesTest
extends ExchangeTestSupport {
    @Test
    public void testParserNodes() {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser(null, "${body} == 'foo'", true, null);
        List nodes = parser.parseTokens();
        Assertions.assertEquals((int)1, (int)nodes.size());
        BinaryExpression be = (BinaryExpression)nodes.get(0);
        Assertions.assertEquals((Object)BinaryOperatorType.EQ, (Object)be.getOperator());
        SingleQuoteStart qe = (SingleQuoteStart)be.getRight();
        LiteralNode ln = (LiteralNode)qe.getBlock().getChildren().get(0);
        Assertions.assertEquals((Object)"foo", (Object)ln.getText());
        SimpleFunctionStart fe = (SimpleFunctionStart)be.getLeft();
        ln = (LiteralNode)fe.getBlock().getChildren().get(0);
        Assertions.assertEquals((Object)"body", (Object)ln.toString());
    }

    @Test
    public void testParserNodesEmbeddedFunction() {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser(null, "${body} != 'Hello ${header.bar}'", true, null);
        List nodes = parser.parseTokens();
        Assertions.assertEquals((int)1, (int)nodes.size());
        BinaryExpression be = (BinaryExpression)nodes.get(0);
        Assertions.assertEquals((Object)BinaryOperatorType.NOT_EQ, (Object)be.getOperator());
        SingleQuoteStart qe = (SingleQuoteStart)be.getRight();
        LiteralNode ln = (LiteralNode)qe.getBlock().getChildren().get(0);
        Assertions.assertEquals((Object)"Hello ", (Object)ln.getText());
        SimpleFunctionStart fe = (SimpleFunctionStart)qe.getBlock().getChildren().get(1);
        ln = (LiteralNode)fe.getBlock().getChildren().get(0);
        Assertions.assertEquals((Object)"header.bar", (Object)ln.toString());
    }
}

