/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.language.simple.SimplePredicateParser;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleParserPredicateTest
extends ExchangeTestSupport {
    @Test
    public void testSimpleBooleanValue() {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "true", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange));
        parser = new SimplePredicateParser((CamelContext)this.context, "false", true, null);
        pre = parser.parsePredicate();
        Assertions.assertFalse((boolean)pre.matches(this.exchange));
    }

    @Test
    public void testSimpleEq() {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body} == 'foo'", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange));
    }

    @Test
    public void testSimpleEqNumeric() {
        this.exchange.getIn().setBody((Object)123);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body} == 123", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleEqFunctionFunction() {
        this.exchange.getIn().setBody((Object)122);
        this.exchange.getIn().setHeader("val", (Object)122);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body} == ${header.val}", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleEqFunctionNumeric() {
        this.exchange.getIn().setBody((Object)122);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body} == 122", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleGtFunctionNumeric() {
        this.exchange.getIn().setBody((Object)122);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body} > 120", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleUnaryInc() {
        this.exchange.getIn().setBody((Object)122);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body}++ == 123", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleUnaryDec() {
        this.exchange.getIn().setBody((Object)122);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body}-- == 121", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleEqFunctionBoolean() {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${header.high} == true", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleEqFunctionBooleanSpaces() {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${header.high}   ==     true", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleLogicalAnd() {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        this.exchange.getIn().setHeader("foo", (Object)123);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${header.high} == true && ${header.foo} == 123", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleLogicalOr() {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        this.exchange.getIn().setHeader("foo", (Object)123);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${header.high} == false || ${header.foo} == 123", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleLogicalAndAnd() {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        this.exchange.getIn().setHeader("foo", (Object)123);
        this.exchange.getIn().setHeader("bar", (Object)"beer");
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${header.high} == true && ${header.foo} == 123 && ${header.bar} == 'beer'", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleManyAndLogical() {
        this.exchange.getIn().setBody((Object)"Hello");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            this.exchange.getIn().setHeader("foo" + i, (Object)i);
            sb.append("${header.foo").append(i).append("} == ").append(i);
            if (i >= 9) continue;
            sb.append(" && ");
        }
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, sb.toString(), true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleManyOrLogical() {
        this.exchange.getIn().setBody((Object)"Hello");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sb.append("${header.foo").append(i).append("} == ").append(i);
            if (i >= 9) continue;
            sb.append(" || ");
        }
        sb.append(" || ${body} == 'Hello'");
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, sb.toString(), true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleExpressionPredicate() {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("number", (Object)"1234");
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${in.header.number} regex '\\d{4}'", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "123");
        map.put("foo bar", "456");
        this.exchange.getIn().setBody(map);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body[foo]} == 123", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
        parser = new SimplePredicateParser((CamelContext)this.context, "${body['foo bar']} == 456", true, null);
        pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
        parser = new SimplePredicateParser((CamelContext)this.context, "${body[foo bar]} == 456", true, null);
        pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
        parser = new SimplePredicateParser((CamelContext)this.context, "${body[unknown]} == 456", true, null);
        pre = parser.parsePredicate();
        Assertions.assertFalse((boolean)pre.matches(this.exchange), (String)"Should not match");
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        list.add("bar");
        jndi.bind("myList", list);
        return jndi;
    }

    @Test
    public void testSimpleIn() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "foo");
        map.put("key2", "bar");
        map.put("key3", "none");
        this.exchange.getIn().setBody(map);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body[key]} in ${ref:myList}", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
        parser = new SimplePredicateParser((CamelContext)this.context, "${body[key2]} in ${ref:myList}", true, null);
        pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
        parser = new SimplePredicateParser((CamelContext)this.context, "${body[key3]} in ${ref:myList}", true, null);
        pre = parser.parsePredicate();
        Assertions.assertFalse((boolean)pre.matches(this.exchange), (String)"Should not match");
    }

    @Test
    public void testSimpleInEmpty() {
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body} in ',,gold,silver'", true, null);
        Predicate pre = parser.parsePredicate();
        this.exchange.getIn().setBody((Object)"gold");
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match gold");
        this.exchange.getIn().setBody((Object)"silver");
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match silver");
        this.exchange.getIn().setBody((Object)"");
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match empty");
        this.exchange.getIn().setBody((Object)"bronze");
        Assertions.assertFalse((boolean)pre.matches(this.exchange), (String)"Should not match bronze");
    }

    @Test
    public void testSimpleWithAmbiguousBinaryOperator() {
        String expression = "${body[value][conditions].getJSONObject(${exchangeProperty[CamelLoopIndex]})[levelType]} == \"1\"\n&& ${body[value][conditions].getJSONObject(${exchangeProperty[CamelLoopIndex]})[minLevel]} != null\n&& ${body[value][conditions].getJSONObject(${exchangeProperty[CamelLoopIndex]})[minLevel]} == \"50\"\n";
        SimplePredicateParser simplePredicateParser = new SimplePredicateParser((CamelContext)this.context, expression, true, new HashMap());
        Predicate predicate = simplePredicateParser.parsePredicate();
        Assertions.assertNotNull((Object)predicate);
    }
}

