/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.language.simple.SimplePredicateParser;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleParserPredicateInvalidTest
extends ExchangeTestSupport {
    @Test
    public void testSimpleEqFunctionInvalid() {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${header.high} == abc", true, null);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> ((SimplePredicateParser)parser).parsePredicate(), (String)"Should thrown exception");
        Assertions.assertEquals((int)19, (int)e.getIndex());
    }

    @Test
    public void testSimpleInvalidSymbol() {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${header.high} = true", true, null);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> ((SimplePredicateParser)parser).parsePredicate(), (String)"Should thrown exception");
        Assertions.assertEquals((int)15, (int)e.getIndex());
    }

    @Test
    public void testSimpleUnevenSingleQuote() {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body} == 'foo", true, null);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> ((SimplePredicateParser)parser).parsePredicate(), (String)"Should thrown exception");
        Assertions.assertEquals((int)14, (int)e.getIndex());
    }

    @Test
    public void testSimpleUnevenDoubleQuote() {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body} == \"foo", true, null);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> ((SimplePredicateParser)parser).parsePredicate(), (String)"Should thrown exception");
        Assertions.assertEquals((int)14, (int)e.getIndex());
    }

    @Test
    public void testSimpleTwoAnd() {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body} == 'foo' && && ${header} == 123", true, null);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> ((SimplePredicateParser)parser).parsePredicate(), (String)"Should thrown exception");
        Assertions.assertEquals((int)20, (int)e.getIndex());
    }

    @Test
    public void testSimpleTwoOr() {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body} == 'foo' || || ${header} == 123", true, null);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> ((SimplePredicateParser)parser).parsePredicate(), (String)"Should thrown exception");
        Assertions.assertEquals((int)20, (int)e.getIndex());
    }

    @Test
    public void testSimpleTwoEq() {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${body} == == 'foo'", true, null);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> ((SimplePredicateParser)parser).parsePredicate(), (String)"Should thrown exception");
        Assertions.assertEquals((int)13, (int)e.getIndex());
    }
}

