/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.language.simple.SimpleExpressionParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleParserExpressionTest
extends ExchangeTestSupport {
    @Test
    public void testSimpleParserEol() {
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "Hello", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"Hello", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testSimpleSingleQuote() {
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "'Hello'", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"'Hello'", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testSimpleStringList() {
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "\"Hello\" \"World\"", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"\"Hello\" \"World\"", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testSimpleSingleQuoteWithFunction() {
        this.exchange.getIn().setBody((Object)"World");
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "'Hello ${body} how are you?'", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"'Hello World how are you?'", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testSimpleSingleQuoteWithFunctionBodyAs() {
        this.exchange.getIn().setBody((Object)"World");
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "'Hello ${bodyAs(String)} how are you?'", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"'Hello World how are you?'", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testSimpleSingleQuoteEol() {
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "'Hello' World", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"'Hello' World", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testSimpleFunction() {
        this.exchange.getIn().setBody((Object)"World");
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "${body}", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"World", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testSimpleSingleQuoteDollar() {
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "Pay 200$ today", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"Pay 200$ today", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testSimpleSingleQuoteDollarEnd() {
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "Pay 200$", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"Pay 200$", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testSimpleUnaryInc() {
        this.exchange.getIn().setBody((Object)"122");
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "${body}++", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"123", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testSimpleUnaryDec() {
        this.exchange.getIn().setBody((Object)"122");
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "${body}--", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"121", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testSimpleUnaryIncInt() {
        this.exchange.getIn().setBody((Object)122);
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "${body}++", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Integer)123, (Integer)((Integer)exp.evaluate(this.exchange, Integer.class)));
    }

    @Test
    public void testSimpleUnaryDecInt() {
        this.exchange.getIn().setBody((Object)122);
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "${body}--", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Integer)121, (Integer)((Integer)exp.evaluate(this.exchange, Integer.class)));
    }

    @Test
    public void testHeaderNestedFunction() {
        this.exchange.getIn().setBody((Object)"foo");
        this.exchange.getIn().setHeader("foo", (Object)"abc");
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "${header.${body}}", true, null);
        Expression exp = parser.parseExpression();
        Object obj = exp.evaluate(this.exchange, Object.class);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertEquals((Object)"abc", (Object)obj);
    }

    @Test
    public void testBodyAsNestedFunction() {
        this.exchange.getIn().setBody((Object)"123");
        this.exchange.getIn().setHeader("foo", (Object)"Integer");
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "${bodyAs(${header.foo})}", true, null);
        Expression exp = parser.parseExpression();
        Object obj = exp.evaluate(this.exchange, Object.class);
        Assertions.assertNotNull((Object)obj);
        Integer num = SimpleParserExpressionTest.assertIsInstanceOf(Integer.class, obj);
        Assertions.assertEquals((int)123, (int)num);
    }

    @Test
    public void testThreeNestedFunctions() {
        this.exchange.getIn().setBody((Object)"123");
        this.exchange.getIn().setHeader("foo", (Object)"Int");
        this.exchange.getIn().setHeader("bar", (Object)"e");
        this.exchange.getIn().setHeader("baz", (Object)"ger");
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "${bodyAs(${header.foo}${header.bar}${header.baz})}", true, null);
        Expression exp = parser.parseExpression();
        Object obj = exp.evaluate(this.exchange, Object.class);
        Assertions.assertNotNull((Object)obj);
        Integer num = SimpleParserExpressionTest.assertIsInstanceOf(Integer.class, obj);
        Assertions.assertEquals((int)123, (int)num);
    }

    @Test
    public void testNestedNestedFunctions() {
        this.exchange.getIn().setBody((Object)"123");
        this.exchange.getIn().setHeader("foo", (Object)"Integer");
        this.exchange.getIn().setHeader("bar", (Object)"foo");
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "${bodyAs(${header.${header.bar}})}", true, null);
        Expression exp = parser.parseExpression();
        Object obj = exp.evaluate(this.exchange, Object.class);
        Assertions.assertNotNull((Object)obj);
        Integer num = SimpleParserExpressionTest.assertIsInstanceOf(Integer.class, obj);
        Assertions.assertEquals((int)123, (int)num);
    }

    @Test
    public void testSimpleMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "123");
        map.put("foo bar", "456");
        this.exchange.getIn().setBody(map);
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "${body[foo]}", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"123", (Object)exp.evaluate(this.exchange, Object.class));
        parser = new SimpleExpressionParser((CamelContext)this.context, "${body['foo bar']}", true, null);
        exp = parser.parseExpression();
        Assertions.assertEquals((Object)"456", (Object)exp.evaluate(this.exchange, Object.class));
    }

    @Test
    public void testUnaryLenient() {
        this.exchange.getIn().setHeader("JMSMessageID", (Object)"JMSMessageID-123");
        this.exchange.getIn().setBody((Object)"THE MSG ID ${header.JMSMessageID} isA --");
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "THE MSG ID ${header.JMSMessageID} isA --", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"THE MSG ID JMSMessageID-123 isA --", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testUnaryLenient2() {
        this.exchange.getIn().setHeader("JMSMessageID", (Object)"JMSMessageID-123");
        this.exchange.getIn().setBody((Object)"------------THE MSG ID ${header.JMSMessageID}------------");
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "------------THE MSG ID ${header.JMSMessageID}------------", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"------------THE MSG ID JMSMessageID-123------------", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testUnaryLenient3() {
        this.exchange.getIn().setHeader("JMSMessageID", (Object)"JMSMessageID-123");
        this.exchange.getIn().setBody((Object)"------------ THE MSG ID ${header.JMSMessageID} ------------");
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "------------ THE MSG ID ${header.JMSMessageID} ------------", true, null);
        Expression exp = parser.parseExpression();
        Assertions.assertEquals((Object)"------------ THE MSG ID JMSMessageID-123 ------------", (Object)exp.evaluate(this.exchange, String.class));
    }
}

