/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.language.simple.SimpleExpressionParser;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleParserExpressionInvalidTest
extends ExchangeTestSupport {
    @Test
    public void testSimpleUnbalanceFunction() {
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "${body is a nice day", true, null);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> ((SimpleExpressionParser)parser).parseExpression(), (String)"Should thrown exception");
        Assertions.assertEquals((int)19, (int)e.getIndex());
    }

    @Test
    public void testSimpleNestedUnbalanceFunction() {
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "${body${foo}", true, null);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> ((SimpleExpressionParser)parser).parseExpression(), (String)"Should thrown exception");
        Assertions.assertEquals((int)11, (int)e.getIndex());
    }

    @Test
    public void testSimpleUnknownFunction() {
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "Hello ${foo} how are you?", true, null);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> ((SimpleExpressionParser)parser).parseExpression(), (String)"Should thrown exception");
        Assertions.assertEquals((int)6, (int)e.getIndex());
    }

    @Test
    public void testSimpleNestedUnknownFunction() {
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "Hello ${bodyAs(${foo})} how are you?", true, null);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> parser.parseExpression().evaluate(this.exchange, String.class), (String)"Should thrown exception");
        Assertions.assertEquals((int)0, (int)e.getIndex());
    }

    @Test
    public void testNoEndFunction() {
        SimpleExpressionParser parser = new SimpleExpressionParser((CamelContext)this.context, "Hello ${body", true, null);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> ((SimpleExpressionParser)parser).parseExpression(), (String)"Should thrown exception");
        Assertions.assertEquals((int)11, (int)e.getIndex());
    }
}

