/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.Exchange;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleOperatorTest
extends LanguageTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("generator", (Object)new MyFileNameGenerator());
        return jndi;
    }

    @Test
    public void testValueWithSpace() {
        this.exchange.getIn().setBody((Object)"Hello Big World");
        this.assertPredicate("${in.body} == 'Hello Big World'", true);
    }

    @Test
    public void testNullValue() {
        this.exchange.getIn().setBody((Object)"Value");
        this.assertPredicate("${in.body} != null", true);
        this.assertPredicate("${body} == null", false);
        this.exchange.getIn().setBody(null);
        this.assertPredicate("${in.body} == null", true);
        this.assertPredicate("${body} != null", false);
    }

    @Test
    public void testEmptyValue() {
        this.exchange.getIn().setBody((Object)"");
        this.assertPredicate("${in.body} == null", false);
        this.assertPredicate("${body} == null", false);
        this.exchange.getIn().setBody((Object)"");
        this.assertPredicate("${in.body} == ''", true);
        this.assertPredicate("${body} == \"\"", true);
        this.exchange.getIn().setBody((Object)" ");
        this.assertPredicate("${in.body} == ''", false);
        this.assertPredicate("${body} == \"\"", false);
        this.exchange.getIn().setBody((Object)"Value");
        this.assertPredicate("${in.body} == ''", false);
        this.assertPredicate("${body} == \"\"", false);
    }

    @Test
    public void testAnd() {
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == 123", true);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == 444", false);
        this.assertPredicate("${in.header.foo} == 'def' && ${in.header.bar} == 123", false);
        this.assertPredicate("${in.header.foo} == 'def' && ${in.header.bar} == 444", false);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} > 100", true);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} < 200", true);
    }

    @Test
    public void testTwoAnd() {
        this.exchange.getIn().setBody((Object)"Hello World");
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == 123 && ${body} == 'Hello World'", true);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == 123 && ${body} == 'Bye World'", false);
    }

    @Test
    public void testThreeAnd() {
        this.exchange.getIn().setBody((Object)"Hello World");
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == 123 && ${body} == 'Hello World' && ${in.header.xx} == null", true);
    }

    @Test
    public void testTwoOr() {
        this.exchange.getIn().setBody((Object)"Hello World");
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} == 44 || ${body} == 'Bye World'", true);
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 44 || ${body} == 'Bye World'", false);
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 44 || ${body} == 'Hello World'", true);
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 123 || ${body} == 'Bye World'", true);
    }

    @Test
    public void testThreeOr() {
        this.exchange.getIn().setBody((Object)"Hello World");
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 44 || ${body} == 'Bye Moon' || ${body} contains 'World'", true);
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 44 || ${body} == 'Bye Moon' || ${body} contains 'Moon'", false);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} == 44 || ${body} == 'Bye Moon' || ${body} contains 'Moon'", true);
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 123 || ${body} == 'Bye Moon' || ${body} contains 'Moon'", true);
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 44 || ${body} == 'Hello World' || ${body} contains 'Moon'", true);
    }

    @Test
    public void testAndWithQuotation() {
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == '123'", true);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == '444'", false);
        this.assertPredicate("${in.header.foo} == 'def' && ${in.header.bar} == '123'", false);
        this.assertPredicate("${in.header.foo} == 'def' && ${in.header.bar} == '444'", false);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} > '100'", true);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} < '200'", true);
    }

    @Test
    public void testOr() {
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} == 123", true);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} == 444", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} == 123", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} == 444", false);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} < 100", true);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} < 200", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} < 200", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} < 100", false);
    }

    @Test
    public void testOrWithQuotation() {
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} == '123'", true);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} == '444'", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} == '123'", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} == '444'", false);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} < '100'", true);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} < '200'", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} < '200'", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} < '100'", false);
    }

    @Test
    public void testEqualOperator() {
        this.assertPredicate("${in.header.foo} == 'abc'", true);
        this.assertPredicate("${in.header.foo} == 'def'", false);
        this.assertPredicate("${in.header.foo} == '1'", false);
        this.assertPredicate("${in.header.foo} == '-'", false);
        this.assertPredicate("${in.header.bar} == '-'", false);
        this.exchange.getIn().setHeader("bool", (Object)true);
        this.exchange.getIn().setHeader("booley", (Object)false);
        this.assertPredicate("${in.header.bool} == true", true);
        this.assertPredicate("${in.header.bool} == 'true'", true);
        this.assertPredicate("${in.header.booley} == false", true);
        this.assertPredicate("${in.header.booley} == 'false'", true);
        this.assertPredicate("${in.header.bar} == '123'", true);
        this.assertPredicate("${in.header.bar} == 123", true);
        this.assertPredicate("${in.header.bar} == '444'", false);
        this.assertPredicate("${in.header.bar} == 444", false);
        this.assertPredicate("${in.header.bar} == '1'", false);
        Assertions.assertEquals((long)0L, (long)this.context.getTypeConverterRegistry().getStatistics().getAttemptCounter());
    }

    @Test
    public void testEqualIgnoreOperator() {
        this.assertPredicate("${in.header.foo} =~ 'abc'", true);
        this.assertPredicate("${in.header.foo} =~ 'ABC'", true);
        this.assertPredicate("${in.header.foo} =~ 'Abc'", true);
        this.assertPredicate("${in.header.foo} =~ 'Def'", false);
        this.assertPredicate("${in.header.foo} =~ '1'", false);
        this.assertPredicate("${in.header.bar} =~ '123'", true);
        this.assertPredicate("${in.header.bar} =~ 123", true);
        this.assertPredicate("${in.header.bar} =~ '444'", false);
        this.assertPredicate("${in.header.bar} =~ 444", false);
        this.assertPredicate("${in.header.bar} =~ '1'", false);
        this.assertPredicate("${in.header.foo} =~ '-'", false);
        this.assertPredicate("${in.header.bar} =~ '-'", false);
    }

    @Test
    public void testNotEqualOperator() {
        this.assertPredicate("${in.header.foo} != 'abc'", false);
        this.assertPredicate("${in.header.foo} != 'def'", true);
        this.assertPredicate("${in.header.foo} != '1'", true);
        this.assertPredicate("${in.header.bar} != '123'", false);
        this.assertPredicate("${in.header.bar} != 123", false);
        this.assertPredicate("${in.header.bar} != '444'", true);
        this.assertPredicate("${in.header.bar} != 444", true);
        this.assertPredicate("${in.header.bar} != '1'", true);
        this.assertPredicate("${in.header.foo} != '-'", true);
        this.assertPredicate("${in.header.bar} != '-'", true);
    }

    @Test
    public void testNotEqualIgnoreOperator() {
        this.assertPredicate("${in.header.foo} !=~ 'abc'", false);
        this.assertPredicate("${in.header.foo} !=~ 'ABC'", false);
        this.assertPredicate("${in.header.foo} !=~ 'Abc'", false);
        this.assertPredicate("${in.header.foo} !=~ 'Def'", true);
        this.assertPredicate("${in.header.foo} !=~ '1'", true);
        this.assertPredicate("${in.header.bar} !=~ '123'", false);
        this.assertPredicate("${in.header.bar} !=~ 123", false);
        this.assertPredicate("${in.header.bar} !=~ '444'", true);
        this.assertPredicate("${in.header.bar} !=~ 444", true);
        this.assertPredicate("${in.header.bar} !=~ '1'", true);
    }

    @Test
    public void testFloatingNumber() {
        this.exchange.getIn().setBody((Object)"0.02");
        this.assertPredicate("${body} > 0", true);
        this.assertPredicate("${body} < 0", false);
        this.assertPredicate("${body} > 0.00", true);
        this.assertPredicate("${body} < 0.00", false);
        this.assertPredicate("${body} > 0.01", true);
        this.assertPredicate("${body} < 0.01", false);
        this.assertPredicate("${body} > 0.02", false);
        this.assertPredicate("${body} < 0.02", false);
        this.assertPredicate("${body} == 0.02", true);
    }

    @Test
    public void testGreaterThanOperator() {
        this.assertPredicate("${in.header.foo} > 'aaa'", true);
        this.assertPredicate("${in.header.foo} > 'def'", false);
        this.assertPredicate("${in.header.bar} > '100'", true);
        this.assertPredicate("${in.header.bar} > 100", true);
        this.assertPredicate("${in.header.bar} > '123'", false);
        this.assertPredicate("${in.header.bar} > 123", false);
        this.assertPredicate("${in.header.bar} > '200'", false);
    }

    @Test
    public void testGreaterThanStringToInt() {
        this.exchange.getIn().setHeader("num", (Object)"70");
        this.assertPredicate("${in.header.num} > 100", false);
        this.assertPredicate("${in.header.num} > 100", false);
        this.assertPredicate("${in.header.num} > 80", false);
        this.assertPredicate("${in.header.num} > 800", false);
        this.assertPredicate("${in.header.num} > 1", true);
        this.assertPredicate("${in.header.num} > 8", true);
        this.assertPredicate("${in.header.num} > 48", true);
        this.assertPredicate("${in.header.num} > 69", true);
        this.assertPredicate("${in.header.num} > 71", false);
        this.assertPredicate("${in.header.num} > 88", false);
        this.assertPredicate("${in.header.num} > 777", false);
    }

    @Test
    public void testLessThanStringToInt() {
        this.exchange.getIn().setHeader("num", (Object)"70");
        this.assertPredicate("${in.header.num} < 100", true);
        this.assertPredicate("${in.header.num} < 100", true);
        this.assertPredicate("${in.header.num} < 80", true);
        this.assertPredicate("${in.header.num} < 800", true);
        this.assertPredicate("${in.header.num} < 1", false);
        this.assertPredicate("${in.header.num} < 8", false);
        this.assertPredicate("${in.header.num} < 48", false);
        this.assertPredicate("${in.header.num} < 69", false);
        this.assertPredicate("${in.header.num} < 71", true);
        this.assertPredicate("${in.header.num} < 88", true);
        this.assertPredicate("${in.header.num} < 777", true);
    }

    @Test
    public void testGreaterThanOrEqualOperator() {
        this.assertPredicate("${in.header.foo} >= 'aaa'", true);
        this.assertPredicate("${in.header.foo} >= 'abc'", true);
        this.assertPredicate("${in.header.foo} >= 'def'", false);
        this.assertPredicate("${in.header.bar} >= '100'", true);
        this.assertPredicate("${in.header.bar} >= 100", true);
        this.assertPredicate("${in.header.bar} >= '123'", true);
        this.assertPredicate("${in.header.bar} >= 123", true);
        this.assertPredicate("${in.header.bar} >= '200'", false);
        this.assertPredicate("${in.header.foo} >= '-'", true);
        this.assertPredicate("${in.header.bar} >= '-'", true);
    }

    @Test
    public void testLessThanOperator() {
        this.assertPredicate("${in.header.foo} < 'aaa'", false);
        this.assertPredicate("${in.header.foo} < 'def'", true);
        this.assertPredicate("${in.header.bar} < '100'", false);
        this.assertPredicate("${in.header.bar} < 100", false);
        this.assertPredicate("${in.header.bar} < '123'", false);
        this.assertPredicate("${in.header.bar} < 123", false);
        this.assertPredicate("${in.header.bar} < '200'", true);
    }

    @Test
    public void testAgainstNegativeValue() {
        this.assertPredicate("${in.header.bar} == 123", true);
        this.assertPredicate("${in.header.bar} == -123", false);
        this.assertPredicate("${in.header.bar} =~ 123", true);
        this.assertPredicate("${in.header.bar} =~ -123", false);
        this.assertPredicate("${in.header.bar} > -123", true);
        this.assertPredicate("${in.header.bar} >= -123", true);
        this.assertPredicate("${in.header.bar} > 123", false);
        this.assertPredicate("${in.header.bar} >= 123", true);
        this.assertPredicate("${in.header.bar} < -123", false);
        this.assertPredicate("${in.header.bar} <= -123", false);
        this.assertPredicate("${in.header.bar} < 123", false);
        this.assertPredicate("${in.header.bar} <= 123", true);
        this.exchange.getIn().setHeader("strNum", (Object)"123");
        this.assertPredicate("${in.header.strNum} contains '123'", true);
        this.assertPredicate("${in.header.strNum} !contains '123'", false);
        this.assertPredicate("${in.header.strNum} contains '-123'", false);
        this.assertPredicate("${in.header.strNum} !contains '-123'", true);
        this.assertPredicate("${in.header.strNum} ~~ '123'", true);
        this.assertPredicate("${in.header.strNum} ~~ '-123'", false);
        this.exchange.getIn().setHeader("num", (Object)-123);
        this.assertPredicate("${in.header.num} == -123", true);
        this.assertPredicate("${in.header.num} == 123", false);
        this.assertPredicate("${in.header.num} =~ -123", true);
        this.assertPredicate("${in.header.num} =~ 123", false);
        this.assertPredicate("${in.header.num} > -123", false);
        this.assertPredicate("${in.header.num} >= -123", true);
        this.assertPredicate("${in.header.num} > 123", false);
        this.assertPredicate("${in.header.num} >= 123", false);
        this.assertPredicate("${in.header.num} < -123", false);
        this.assertPredicate("${in.header.num} <= -123", true);
        this.assertPredicate("${in.header.num} < 123", true);
        this.assertPredicate("${in.header.num} <= 123", true);
        this.exchange.getIn().setHeader("strNumNegative", (Object)"-123");
        this.assertPredicate("${in.header.strNumNegative} contains '123'", true);
        this.assertPredicate("${in.header.strNumNegative} !contains '123'", false);
        this.assertPredicate("${in.header.strNumNegative} contains '-123'", true);
        this.assertPredicate("${in.header.strNumNegative} !contains '-123'", false);
        this.assertPredicate("${in.header.strNumNegative} ~~ '123'", true);
        this.assertPredicate("${in.header.strNumNegative} ~~ '-123'", true);
    }

    @Test
    public void testLessThanOrEqualOperator() {
        this.assertPredicate("${in.header.foo} <= 'aaa'", false);
        this.assertPredicate("${in.header.foo} <= 'abc'", true);
        this.assertPredicate("${in.header.foo} <= 'def'", true);
        this.exchange.getIn().setHeader("dude", (Object)"555");
        this.exchange.getIn().setHeader("dude2", (Object)"0099");
        this.assertPredicate("${in.header.dude} <= ${in.header.dude}", true);
        this.assertPredicate("${in.header.dude2} <= ${in.header.dude}", true);
        this.assertPredicate("${in.header.bar} <= '100'", false);
        this.assertPredicate("${in.header.bar} <= 100", false);
        this.assertPredicate("${in.header.bar} <= '123'", true);
        this.assertPredicate("${in.header.bar} <= 123", true);
        this.assertPredicate("${in.header.bar} <= '200'", true);
        Assertions.assertEquals((long)0L, (long)this.context.getTypeConverterRegistry().getStatistics().getAttemptCounter());
    }

    @Test
    public void testTypeCoerceNoConversionNeeded() {
        this.exchange.getIn().setHeader("num", (Object)70);
        this.assertPredicate("${in.header.num} > 100", false);
        this.assertPredicate("${in.header.num} < 100", true);
        this.assertPredicate("${in.header.num} == 70", true);
        this.assertPredicate("${in.header.num} != 70", false);
        this.assertPredicate("${in.header.num} > 100", false);
        this.assertPredicate("${in.header.num} > 80", false);
        this.assertPredicate("${in.header.num} > 800", false);
        this.assertPredicate("${in.header.num} < 800", true);
        this.assertPredicate("${in.header.num} > 1", true);
        this.assertPredicate("${in.header.num} > 8", true);
        this.assertPredicate("${in.header.num} > 48", true);
        this.assertPredicate("${in.header.num} > 69", true);
        this.assertPredicate("${in.header.num} > 71", false);
        this.assertPredicate("${in.header.num} < 71", true);
        this.assertPredicate("${in.header.num} > 88", false);
        this.assertPredicate("${in.header.num} > 777", false);
        this.exchange.getIn().setHeader("num", (Object)"70");
        this.assertPredicate("${in.header.num} > 100", false);
        this.assertPredicate("${in.header.num} < 100", true);
        this.assertPredicate("${in.header.num} == 70", true);
        this.assertPredicate("${in.header.num} != 70", false);
        this.assertPredicate("${in.header.num} > 100", false);
        this.assertPredicate("${in.header.num} > 80", false);
        this.assertPredicate("${in.header.num} > 800", false);
        this.assertPredicate("${in.header.num} < 800", true);
        this.assertPredicate("${in.header.num} > 1", true);
        this.assertPredicate("${in.header.num} > 8", true);
        this.assertPredicate("${in.header.num} > 48", true);
        this.assertPredicate("${in.header.num} > 69", true);
        this.assertPredicate("${in.header.num} > 71", false);
        this.assertPredicate("${in.header.num} < 71", true);
        this.assertPredicate("${in.header.num} > 88", false);
        this.assertPredicate("${in.header.num} > 777", false);
        Assertions.assertEquals((long)0L, (long)this.context.getTypeConverterRegistry().getStatistics().getAttemptCounter());
    }

    @Test
    public void testIsNull() {
        this.assertPredicate("${in.header.foo} == null", false);
        this.assertPredicate("${in.header.none} == null", true);
    }

    @Test
    public void testIsNotNull() {
        this.assertPredicate("${in.header.foo} != null", true);
        this.assertPredicate("${in.header.none} != null", false);
    }

    @Test
    public void testRightOperatorIsSimpleLanguage() {
        this.assertPredicate("${in.header.foo} == ${in.header.foo}", true);
        this.assertPredicate("${in.header.foo} == ${in.header.bar}", false);
    }

    @Test
    public void testRightOperatorIsBeanLanguage() {
        this.assertPredicate("${in.header.foo} == ${bean:generator.generateFilename}", true);
        this.assertPredicate("${in.header.bar} == ${bean:generator.generateId}", true);
        this.assertPredicate("${in.header.bar} >= ${bean:generator.generateId}", true);
    }

    @Test
    public void testContains() {
        this.assertPredicate("${in.header.foo} contains 'a'", true);
        this.assertPredicate("${in.header.foo} contains 'ab'", true);
        this.assertPredicate("${in.header.foo} contains 'abc'", true);
        this.assertPredicate("${in.header.foo} contains 'def'", false);
    }

    @Test
    public void testContainsNumberInString() {
        this.exchange.getMessage().setBody((Object)"The answer is 42 and is the answer to life the universe and everything");
        this.assertPredicate("${body} contains '42'", true);
        this.assertPredicate("${body} contains 42", true);
        this.assertPredicate("${body} contains '77'", false);
        this.assertPredicate("${body} contains 77", false);
    }

    @Test
    public void testNotContains() {
        this.assertPredicate("${in.header.foo} not contains 'a'", false);
        this.assertPredicate("${in.header.foo} not contains 'ab'", false);
        this.assertPredicate("${in.header.foo} not contains 'abc'", false);
        this.assertPredicate("${in.header.foo} not contains 'def'", true);
        this.assertPredicate("${in.header.foo} !contains 'a'", false);
        this.assertPredicate("${in.header.foo} !contains 'ab'", false);
        this.assertPredicate("${in.header.foo} !contains 'abc'", false);
        this.assertPredicate("${in.header.foo} !contains 'def'", true);
    }

    @Test
    public void testContainsIgnoreCase() {
        this.assertPredicate("${in.header.foo} ~~ 'A'", true);
        this.assertPredicate("${in.header.foo} ~~ 'Ab'", true);
        this.assertPredicate("${in.header.foo} ~~ 'Abc'", true);
        this.assertPredicate("${in.header.foo} ~~ 'defG'", false);
    }

    @Test
    public void testNotContainsIgnoreCase() {
        this.assertPredicate("${in.header.foo} !~~ 'A'", false);
        this.assertPredicate("${in.header.foo} !~~ 'Ab'", false);
        this.assertPredicate("${in.header.foo} !~~ 'Abc'", false);
        this.assertPredicate("${in.header.foo} !~~ 'defG'", true);
    }

    @Test
    public void testRegex() {
        this.assertPredicate("${in.header.foo} regex '^a..$'", true);
        this.assertPredicate("${in.header.foo} regex '^ab.$'", true);
        this.assertPredicate("${in.header.foo} regex '^ab.$'", true);
        this.assertPredicate("${in.header.foo} regex '^d.*$'", false);
        this.assertPredicate("${in.header.bar} regex '^\\d{3}'", true);
        this.assertPredicate("${in.header.bar} regex '^\\d{2}'", false);
    }

    @Test
    public void testNotRegex() {
        this.assertPredicate("${in.header.foo} not regex '^a..$'", false);
        this.assertPredicate("${in.header.foo} not regex '^ab.$'", false);
        this.assertPredicate("${in.header.foo} not regex '^ab.$'", false);
        this.assertPredicate("${in.header.foo} not regex '^d.*$'", true);
        this.assertPredicate("${in.header.bar} not regex '^\\d{3}'", false);
        this.assertPredicate("${in.header.bar} not regex '^\\d{2}'", true);
    }

    @Test
    public void testIn() {
        this.assertPredicate("${in.header.foo} in 'foo,abc,def'", true);
        this.assertPredicate("${in.header.foo} in ${bean:generator.generateFilename}", true);
        this.assertPredicate("${in.header.foo} in 'foo,abc,def'", true);
        this.assertPredicate("${in.header.foo} in 'foo,def'", false);
        this.assertPredicate("${in.header.bar} in '100,123,200'", true);
        this.assertPredicate("${in.header.bar} in ${bean:generator.generateId}", true);
        this.assertPredicate("${in.header.bar} in '100,200'", false);
    }

    @Test
    public void testNotIn() {
        this.assertPredicate("${in.header.foo} not in 'foo,abc,def'", false);
        this.assertPredicate("${in.header.foo} not in ${bean:generator.generateFilename}", false);
        this.assertPredicate("${in.header.foo} not in 'foo,abc,def'", false);
        this.assertPredicate("${in.header.foo} not in 'foo,def'", true);
        this.assertPredicate("${in.header.foo} !in 'foo,abc,def'", false);
        this.assertPredicate("${in.header.foo} !in ${bean:generator.generateFilename}", false);
        this.assertPredicate("${in.header.foo} !in 'foo,abc,def'", false);
        this.assertPredicate("${in.header.foo} !in 'foo,def'", true);
        this.assertPredicate("${in.header.bar} not in '100,123,200'", false);
        this.assertPredicate("${in.header.bar} not in ${bean:generator.generateId}", false);
        this.assertPredicate("${in.header.bar} not in '100,200'", true);
        this.assertPredicate("${in.header.bar} !in '100,123,200'", false);
        this.assertPredicate("${in.header.bar} !in ${bean:generator.generateId}", false);
        this.assertPredicate("${in.header.bar} !in '100,200'", true);
    }

    @Test
    public void testIs() {
        this.assertPredicate("${in.header.foo} is 'java.lang.String'", true);
        this.assertPredicate("${in.header.foo} is 'java.lang.Integer'", false);
        this.assertPredicate("${in.header.foo} is 'String'", true);
        this.assertPredicate("${in.header.foo} is 'Integer'", false);
        SimpleIllegalSyntaxException e = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertPredicate("${in.header.foo} is com.mycompany.DoesNotExist", false), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)20, (int)e.getIndex());
    }

    @Test
    public void testIsNot() {
        this.assertPredicate("${in.header.foo} not is 'java.lang.String'", false);
        this.assertPredicate("${in.header.foo} not is 'java.lang.Integer'", true);
        this.assertPredicate("${in.header.foo} !is 'java.lang.String'", false);
        this.assertPredicate("${in.header.foo} !is 'java.lang.Integer'", true);
        this.assertPredicate("${in.header.foo} not is 'String'", false);
        this.assertPredicate("${in.header.foo} not is 'Integer'", true);
        this.assertPredicate("${in.header.foo} !is 'String'", false);
        this.assertPredicate("${in.header.foo} !is 'Integer'", true);
        SimpleIllegalSyntaxException e1 = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertPredicate("${in.header.foo} not is com.mycompany.DoesNotExist", false), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)24, (int)e1.getIndex());
        SimpleIllegalSyntaxException e2 = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertPredicate("${in.header.foo} !is com.mycompany.DoesNotExist", false), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)21, (int)e2.getIndex());
    }

    @Test
    public void testRange() {
        this.assertPredicate("${in.header.bar} range '100..200'", true);
        this.assertPredicate("${in.header.bar} range '200..300'", false);
        this.assertPredicate("${in.header.foo} range '200..300'", false);
        this.assertPredicate("${bean:generator.generateId} range '123..130'", true);
        this.assertPredicate("${bean:generator.generateId} range '120..123'", true);
        this.assertPredicate("${bean:generator.generateId} range '120..122'", false);
        this.assertPredicate("${bean:generator.generateId} range '124..130'", false);
        SimpleIllegalSyntaxException e1 = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertPredicate("${in.header.foo} range abc..200", false), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)23, (int)e1.getIndex());
        SimpleIllegalSyntaxException e2 = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertPredicate("${in.header.foo} range abc..", false), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)23, (int)e2.getIndex());
        SimpleIllegalSyntaxException e3 = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertPredicate("${in.header.foo} range 100.200", false), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)30, (int)e3.getIndex());
        this.assertPredicate("${in.header.bar} range '100..200' && ${in.header.foo} == 'abc'", true);
        this.assertPredicate("${in.header.bar} range '200..300' && ${in.header.foo} == 'abc'", false);
        this.assertPredicate("${in.header.bar} range '200..300' || ${in.header.foo} == 'abc'", true);
        this.assertPredicate("${in.header.bar} range '200..300' || ${in.header.foo} == 'def'", false);
    }

    @Test
    public void testNotRange() {
        this.assertPredicate("${in.header.bar} not range '100..200'", false);
        this.assertPredicate("${in.header.bar} not range '200..300'", true);
        this.assertPredicate("${in.header.bar} !range '100..200'", false);
        this.assertPredicate("${in.header.bar} !range '200..300'", true);
        this.assertPredicate("${in.header.foo} not range '200..300'", true);
        this.assertPredicate("${bean:generator.generateId} not range '123..130'", false);
        this.assertPredicate("${bean:generator.generateId} not range '120..123'", false);
        this.assertPredicate("${bean:generator.generateId} not range '120..122'", true);
        this.assertPredicate("${bean:generator.generateId} not range '124..130'", true);
        this.assertPredicate("${in.header.foo} !range '200..300'", true);
        this.assertPredicate("${bean:generator.generateId} !range '123..130'", false);
        this.assertPredicate("${bean:generator.generateId} !range '120..123'", false);
        this.assertPredicate("${bean:generator.generateId} !range '120..122'", true);
        this.assertPredicate("${bean:generator.generateId} !range '124..130'", true);
        SimpleIllegalSyntaxException e1 = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertPredicate("${in.header.foo} not range abc..200", false), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)27, (int)e1.getIndex());
        SimpleIllegalSyntaxException e2 = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertPredicate("${in.header.foo} !range abc..200", false), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)24, (int)e2.getIndex());
        SimpleIllegalSyntaxException e3 = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertPredicate("${in.header.foo} not range abc..", false), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)27, (int)e3.getIndex());
        SimpleIllegalSyntaxException e4 = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertPredicate("${in.header.foo} !range abc..", false), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)24, (int)e4.getIndex());
        SimpleIllegalSyntaxException e5 = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertPredicate("${in.header.foo} not range 100.200", false), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)34, (int)e5.getIndex());
        SimpleIllegalSyntaxException e6 = (SimpleIllegalSyntaxException)Assertions.assertThrows(SimpleIllegalSyntaxException.class, () -> this.assertPredicate("${in.header.foo} !range 100.200", false), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)31, (int)e6.getIndex());
    }

    @Test
    public void testUnaryInc() {
        this.assertExpression("${in.header.bar}++", 124);
        this.assertExpression("+++++++++++++", "+++++++++++++");
        this.assertExpression("Logging ++ start ++", "Logging ++ start ++");
        this.assertExpression("Logging +++ start +++", "Logging +++ start +++");
        this.assertExpression("++ start ++", "++ start ++");
        this.assertExpression("+++ start +++", "+++ start +++");
        this.assertPredicate("${in.header.bar}++ == 122", false);
        this.assertPredicate("${in.header.bar}++ == 123", false);
        this.assertPredicate("${in.header.bar}++ == 124", true);
    }

    @Test
    public void testUnaryDec() {
        this.assertExpression("${in.header.bar}--", 122);
        this.assertExpression("-------------", "-------------");
        this.assertExpression("Logging -- start --", "Logging -- start --");
        this.assertExpression("Logging --- start ---", "Logging --- start ---");
        this.assertExpression("-- start --", "-- start --");
        this.assertExpression("--- start ---", "--- start ---");
        this.assertPredicate("${in.header.bar}-- == 122", true);
        this.assertPredicate("${in.header.bar}-- == 123", false);
        this.assertPredicate("${in.header.bar}-- == 124", false);
    }

    @Test
    public void testStartsWith() {
        this.exchange.getIn().setBody((Object)"Hello there");
        this.assertPredicate("${in.body} starts with 'Hello'", true);
        this.assertPredicate("${in.body} starts with 'H'", true);
        this.assertPredicate("${in.body} starts with 'Hello there'", true);
        this.assertPredicate("${in.body} starts with 'Hello ther'", true);
        this.assertPredicate("${in.body} starts with 'ello there'", false);
        this.assertPredicate("${in.body} starts with 'Hi'", false);
        this.assertPredicate("${in.body} startsWith 'Hello'", true);
        this.assertPredicate("${in.body} startsWith 'H'", true);
        this.assertPredicate("${in.body} startsWith 'Hello there'", true);
        this.assertPredicate("${in.body} startsWith 'Hello ther'", true);
        this.assertPredicate("${in.body} startsWith 'ello there'", false);
        this.assertPredicate("${in.body} startsWith 'Hi'", false);
    }

    @Test
    public void testStartsWithTextAsNumeric() {
        this.exchange.getIn().setBody((Object)"01234");
        this.assertPredicate("${in.body} starts with '1234'", false);
        this.assertPredicate("${in.body} starts with 1234", false);
        this.assertPredicate("${in.body} starts with '01234'", true);
        this.assertPredicate("${in.body} starts with \"01234\"", true);
        this.assertPredicate("${in.body} starts with 01234", false);
    }

    @Test
    public void testEndsWith() {
        this.exchange.getIn().setBody((Object)"Hello there");
        this.assertPredicate("${in.body} ends with 'there'", true);
        this.assertPredicate("${in.body} ends with 're'", true);
        this.assertPredicate("${in.body} ends with ' there'", true);
        this.assertPredicate("${in.body} ends with 'Hello there'", true);
        this.assertPredicate("${in.body} ends with 'Hello ther'", false);
        this.assertPredicate("${in.body} ends with 'Hi'", false);
        this.assertPredicate("${in.body} endsWith 'there'", true);
        this.assertPredicate("${in.body} endsWith 're'", true);
        this.assertPredicate("${in.body} endsWith ' there'", true);
        this.assertPredicate("${in.body} endsWith 'Hello there'", true);
        this.assertPredicate("${in.body} endsWith 'Hello ther'", false);
        this.assertPredicate("${in.body} endsWith 'Hi'", false);
    }

    @Override
    protected String getLanguageName() {
        return "simple";
    }

    public static class MyFileNameGenerator {
        public String generateFilename(Exchange exchange) {
            return "abc";
        }

        public int generateId(Exchange exchange) {
            return 123;
        }
    }
}

