/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleMessageHistoryTest
extends ContextTestSupport {
    @Test
    public void testMessageHistory() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String result = (String)((Exchange)this.getMockEndpoint("mock:result").getExchanges().get(0)).getIn().getBody(String.class);
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.contains("mock:a"));
        Assertions.assertTrue((boolean)result.contains("mock:b"));
        Assertions.assertTrue((boolean)result.contains("transform[simple{${messageHistory}}"));
        Assertions.assertTrue((boolean)result.contains("Hello World"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                SimpleMessageHistoryTest.this.context.setMessageHistory(Boolean.valueOf(true));
                ((ProcessorDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:a")).log("${messageHistory}")).to("mock:b")).log("${messageHistory}")).transform().simple("${messageHistory}")).to("mock:result");
            }
        };
    }
}

