/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.camel.Expression;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.converter.IOConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleInheritanceIssueTest
extends LanguageTestSupport {
    @Override
    protected String getLanguageName() {
        return "simple";
    }

    @Test
    public void testMethodCall() {
        MySingleParser parser = new MySingleParser();
        this.exchange.getIn().setBody((Object)parser);
        Expression expression = this.context.resolveLanguage("simple").createExpression("${body.parse('data')}");
        String result = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertEquals((Object)"data", (Object)result);
    }

    @Test
    public void testMethodCallHeader() {
        MySingleParser parser = new MySingleParser();
        this.exchange.getIn().setBody((Object)parser);
        ByteArrayInputStream bais = new ByteArrayInputStream("data".getBytes());
        this.exchange.getIn().setHeader("input", (Object)bais);
        Expression expression = this.context.resolveLanguage("simple").createExpression("${body.parse(${header.input})}");
        String result = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertEquals((Object)"data", (Object)result);
    }

    @Test
    public void testMethodCallOverloadedHeader() {
        MyParser parser = new MyParser();
        this.exchange.getIn().setBody((Object)parser);
        ByteArrayInputStream bais = new ByteArrayInputStream("data".getBytes());
        this.exchange.getIn().setHeader("input", (Object)bais);
        Expression expression = this.context.resolveLanguage("simple").createExpression("${body.parse(${header.input})}");
        String result = (String)expression.evaluate(this.exchange, String.class);
        Assertions.assertEquals((Object)"data", (Object)result);
    }

    public static class MySingleParser {
        public String parse(byte[] input) {
            return new String(input);
        }
    }

    public static class MyParser {
        public String parse(byte[] input) {
            return "array";
        }

        public String parse(InputStream input) throws Exception {
            return IOConverter.toString((InputStream)input, null);
        }
    }
}

