/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.List;
import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.language.simple.SimpleExpressionParser;
import org.apache.camel.language.simple.ast.LiteralNode;
import org.apache.camel.language.simple.ast.SimpleFunctionStart;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleExpressionParserNodesTest
extends ExchangeTestSupport {
    @Test
    public void testParserNodes() {
        this.exchange.getIn().setBody((Object)"foo");
        SimpleExpressionParser parser = new SimpleExpressionParser(null, "Hello ${body}", true, null);
        List nodes = parser.parseTokens();
        Assertions.assertEquals((int)2, (int)nodes.size());
        LiteralNode ln = (LiteralNode)nodes.get(0);
        Assertions.assertEquals((Object)"Hello ", (Object)ln.getText());
        SimpleFunctionStart fe = (SimpleFunctionStart)nodes.get(1);
        ln = (LiteralNode)fe.getBlock().getChildren().get(0);
        Assertions.assertEquals((Object)"body", (Object)ln.toString());
    }

    @Test
    public void testParserNodesEmbeddedFunction() {
        this.exchange.getIn().setBody((Object)"foo");
        SimpleExpressionParser parser = new SimpleExpressionParser(null, "Hello ${body} and ${header.bar}", true, null);
        List nodes = parser.parseTokens();
        Assertions.assertEquals((int)4, (int)nodes.size());
        LiteralNode ln = (LiteralNode)nodes.get(0);
        Assertions.assertEquals((Object)"Hello ", (Object)ln.getText());
        SimpleFunctionStart fe = (SimpleFunctionStart)nodes.get(1);
        ln = (LiteralNode)fe.getBlock().getChildren().get(0);
        Assertions.assertEquals((Object)"body", (Object)ln.toString());
        ln = (LiteralNode)nodes.get(2);
        Assertions.assertEquals((Object)" and ", (Object)ln.getText());
        fe = (SimpleFunctionStart)nodes.get(3);
        ln = (LiteralNode)fe.getBlock().getChildren().get(0);
        Assertions.assertEquals((Object)"header.bar", (Object)ln.toString());
    }
}

