/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.LanguageTestSupport;
import org.junit.jupiter.api.Test;

public class SimpleCacheExpressionTest
extends LanguageTestSupport {
    @Override
    protected String getLanguageName() {
        return "simple";
    }

    @Test
    public void testCachingExpression() {
        this.exchange.getIn().setHeader("foo", (Object)123);
        this.assertExpression(this.exchange, "header.foo", (Object)"header.foo");
        this.assertExpression(this.exchange, "${header.foo}", 123);
    }

    @Test
    public void testReverseCachingExpression() {
        this.exchange.getIn().setHeader("foo", (Object)123);
        this.assertExpression(this.exchange, "${header.foo}", 123);
        this.assertExpression(this.exchange, "header.foo", (Object)"header.foo");
    }

    @Test
    public void testCachingWithNestedFunction() {
        MyConverter converter = new MyConverter();
        this.exchange.getIn().setBody((Object)converter);
        this.exchange.getIn().setHeader("input", (Object)"foo");
        this.assertExpression(this.exchange, "${body.upper(${header.input})}", (Object)"FOO");
        this.assertExpression(this.exchange, "body.upper(${header.input})", (Object)"body.upper(foo)");
    }

    @Test
    public void testReversedCachingWithNestedFunction() {
        MyConverter converter = new MyConverter();
        this.exchange.getIn().setBody((Object)converter);
        this.exchange.getIn().setHeader("input", (Object)"foo");
        this.assertExpression(this.exchange, "body.upper(${header.input})", (Object)"body.upper(foo)");
        this.assertExpression(this.exchange, "${body.upper(${header.input})}", (Object)"FOO");
    }

    public static class MyConverter {
        public String upper(String input) {
            return input.toUpperCase();
        }
    }
}

