/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.CamelContext;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.language.simple.SimplePredicateParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleBackwardsCompatibleTest
extends LanguageTestSupport {
    @Override
    protected String getLanguageName() {
        return "simple";
    }

    @Test
    public void testSimpleBody() {
        this.assertExpression(this.exchange, "${body}", (Object)"<hello id='m123'>world!</hello>");
        this.assertPredicate("${body}", true);
    }

    @Test
    public void testSimpleHeader() {
        this.exchange.getIn().setHeader("foo", (Object)123);
        this.assertExpression(this.exchange, "${header.foo}", 123);
        this.assertPredicate("${header.foo}", true);
        this.assertPredicate("${header.unknown}", false);
    }

    @Test
    public void testSimpleLogicalAnd() {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        this.exchange.getIn().setHeader("foo", (Object)123);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${header.high} == true && ${header.foo} == 123", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }

    @Test
    public void testSimpleLogicalOr() {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        this.exchange.getIn().setHeader("foo", (Object)123);
        SimplePredicateParser parser = new SimplePredicateParser((CamelContext)this.context, "${header.high} == false || ${header.foo} == 123", true, null);
        Predicate pre = parser.parsePredicate();
        Assertions.assertTrue((boolean)pre.matches(this.exchange), (String)"Should match");
    }
}

