/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.language.simple.MyCloneBean;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InvokeCloneTest
extends ContextTestSupport {
    @Test
    public void invokeClone() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        MyCloneBean source = new MyCloneBean(5);
        this.template.sendBody("direct:startClone", (Object)source);
        mock.assertIsSatisfied();
        MyCloneBean target = (MyCloneBean)((Exchange)mock.getReceivedExchanges().get(0)).getMessage().getBody(MyCloneBean.class);
        Assertions.assertNotNull((Object)target);
        Assertions.assertNotSame((Object)source, (Object)target);
        Assertions.assertEquals((int)source.getMyField(), (int)target.getMyField());
    }

    @Test
    public void invokeDeepCopy() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        MyCloneBean source = new MyCloneBean(5);
        this.template.sendBody("direct:startDeepCopy", (Object)source);
        mock.assertIsSatisfied();
        MyCloneBean target = (MyCloneBean)((Exchange)mock.getReceivedExchanges().get(0)).getMessage().getBody(MyCloneBean.class);
        Assertions.assertNotNull((Object)target);
        Assertions.assertNotSame((Object)source, (Object)target);
        Assertions.assertEquals((int)source.getMyField(), (int)target.getMyField());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:startClone").to("language://simple:${body.clone()}")).to("mock:result")).end();
                ((RouteDefinition)((RouteDefinition)this.from("direct:startDeepCopy").to("language://simple:${body.deepCopy()}")).to("mock:result")).end();
            }
        };
    }
}

