/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.csimple;

import org.apache.camel.language.csimple.CSimplePredicateParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CSimplePredicateParserTest {
    @Test
    public void testParse() {
        CSimplePredicateParser parser = new CSimplePredicateParser();
        String code = parser.parsePredicate("'bar' != 'foo'");
        Assertions.assertEquals((Object)"isNotEqualTo(exchange, \"bar\", \"foo\")", (Object)code);
        code = parser.parsePredicate("${body} == 'foo'");
        Assertions.assertEquals((Object)"isEqualTo(exchange, body, \"foo\")", (Object)code);
        code = parser.parsePredicate("${body} != 'foo'");
        Assertions.assertEquals((Object)"isNotEqualTo(exchange, body, \"foo\")", (Object)code);
        code = parser.parsePredicate("${body} == 123");
        Assertions.assertEquals((Object)"isEqualTo(exchange, body, 123)", (Object)code);
        code = parser.parsePredicate("${body} > 9.95");
        Assertions.assertEquals((Object)"isGreaterThan(exchange, body, 9.95d)", (Object)code);
        code = parser.parsePredicate("${body} > 123456789012345");
        Assertions.assertEquals((Object)"isGreaterThan(exchange, body, 123456789012345l)", (Object)code);
        code = parser.parsePredicate("${bodyAs(int)} == 123");
        Assertions.assertEquals((Object)"isEqualTo(exchange, bodyAs(message, int.class), 123)", (Object)code);
        code = parser.parsePredicate("${bodyAs(String).length()} == 4");
        Assertions.assertEquals((Object)"isEqualTo(exchange, bodyAs(message, String.class).length(), 4)", (Object)code);
        code = parser.parsePredicate("${bodyAs(String).substring(3)} == 'DEF'");
        Assertions.assertEquals((Object)"isEqualTo(exchange, bodyAs(message, String.class).substring(3), \"DEF\")", (Object)code);
        code = parser.parsePredicate("${bodyAs(int)} > ${headerAs('foo', int)}");
        Assertions.assertEquals((Object)"isGreaterThan(exchange, bodyAs(message, int.class), headerAs(message, \"foo\", int.class))", (Object)code);
        code = parser.parsePredicate("${camelContext.getName()} == 'myCamel'");
        Assertions.assertEquals((Object)"isEqualTo(exchange, context.getName(), \"myCamel\")", (Object)code);
        code = parser.parsePredicate("${camelContext.name} == 'myCamel'");
        Assertions.assertEquals((Object)"isEqualTo(exchange, context.getName(), \"myCamel\")", (Object)code);
        code = parser.parsePredicate("${camelContext.inflightRepository.size()} > 0");
        Assertions.assertEquals((Object)"isGreaterThan(exchange, context.getInflightRepository().size(), 0)", (Object)code);
    }

    @Test
    public void testParseEmbeddedFunctions() {
        CSimplePredicateParser parser = new CSimplePredicateParser();
        String code = parser.parsePredicate("${body.substring(1, ${header.max})} == 'foo'");
        Assertions.assertEquals((Object)"isEqualTo(exchange, body.substring(1, header(message, \"max\")), \"foo\")", (Object)code);
    }

    @Test
    public void testParseSysFunctions() {
        CSimplePredicateParser parser = new CSimplePredicateParser();
        String code = parser.parsePredicate("${sys.foo} != 'bar'");
        Assertions.assertEquals((Object)"isNotEqualTo(exchange, sys(\"foo\"), \"bar\")", (Object)code);
        code = parser.parsePredicate("${env.foo} != 'bar'");
        Assertions.assertEquals((Object)"isNotEqualTo(exchange, sysenv(\"foo\"), \"bar\")", (Object)code);
        code = parser.parsePredicate("${env:FOO} != 'bar'");
        Assertions.assertEquals((Object)"isNotEqualTo(exchange, sysenv(\"FOO\"), \"bar\")", (Object)code);
    }

    @Test
    public void testParseExchangeProperty() {
        CSimplePredicateParser parser = new CSimplePredicateParser();
        String code = parser.parsePredicate("${exchangeProperty.foo} != 'bar'");
        Assertions.assertEquals((Object)"isNotEqualTo(exchange, exchangeProperty(exchange, \"foo\"), \"bar\")", (Object)code);
        code = parser.parsePredicate("${exchangeProperty[foo]} != 'bar'");
        Assertions.assertEquals((Object)"isNotEqualTo(exchange, exchangeProperty(exchange, \"foo\"), \"bar\")", (Object)code);
        code = parser.parsePredicate("${exchangePropertyAs(foo, com.foo.User)} != 'bar'");
        Assertions.assertEquals((Object)"isNotEqualTo(exchange, exchangePropertyAs(exchange, \"foo\", com.foo.User.class), \"bar\")", (Object)code);
        code = parser.parsePredicate("${exchangePropertyAs(foo, com.foo.User).name} != 'bar'");
        Assertions.assertEquals((Object)"isNotEqualTo(exchange, exchangePropertyAs(exchange, \"foo\", com.foo.User.class).getName(), \"bar\")", (Object)code);
        code = parser.parsePredicate("${exchangePropertyAs(foo, com.foo.User).getName()} != 'bar'");
        Assertions.assertEquals((Object)"isNotEqualTo(exchange, exchangePropertyAs(exchange, \"foo\", com.foo.User.class).getName(), \"bar\")", (Object)code);
    }
}

