/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.csimple;

import org.apache.camel.language.csimple.CSimpleExpressionParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CSimpleExpressionParserTest {
    @Test
    public void testParse() {
        CSimpleExpressionParser parser = new CSimpleExpressionParser();
        String code = parser.parseExpression("Hello World");
        Assertions.assertEquals((Object)"\"Hello World\"", (Object)code);
        code = parser.parseExpression("'Hello World'");
        Assertions.assertEquals((Object)"\"Hello World\"", (Object)code);
        code = parser.parseExpression("Hello ${body}");
        Assertions.assertEquals((Object)"\"Hello \" + body", (Object)code);
        code = parser.parseExpression("Hello ${body} how are you?");
        Assertions.assertEquals((Object)"\"Hello \" + body + \" how are you?\"", (Object)code);
    }

    @Test
    public void testIncDec() {
        CSimpleExpressionParser parser = new CSimpleExpressionParser();
        String code = parser.parseExpression("${body}++");
        Assertions.assertEquals((Object)"increment(exchange, body)", (Object)code);
        code = parser.parseExpression("${header.number}--");
        Assertions.assertEquals((Object)"decrement(exchange, header(message, \"number\"))", (Object)code);
    }

    @Test
    public void testMisc() {
        CSimpleExpressionParser parser = new CSimpleExpressionParser();
        String code = parser.parseExpression("${random(10)}");
        Assertions.assertEquals((Object)"random(exchange, 0, 10)", (Object)code);
        code = parser.parseExpression("${random(10, 20)}");
        Assertions.assertEquals((Object)"random(exchange, 10, 20)", (Object)code);
        code = parser.parseExpression("${random(10, ${header.max})}");
        Assertions.assertEquals((Object)"random(exchange, 10, header(message, \"max\"))", (Object)code);
        code = parser.parseExpression("${random(${header.min}, ${header.max})}");
        Assertions.assertEquals((Object)"random(exchange, header(message, \"min\"), header(message, \"max\"))", (Object)code);
        code = parser.parseExpression("${skip(10)}");
        Assertions.assertEquals((Object)"skip(exchange, 10)", (Object)code);
        code = parser.parseExpression("${skip(${header.max})}");
        Assertions.assertEquals((Object)"skip(exchange, header(message, \"max\"))", (Object)code);
        code = parser.parseExpression("${collate(10)}");
        Assertions.assertEquals((Object)"collate(exchange, 10)", (Object)code);
        code = parser.parseExpression("${collate(${header.max})}");
        Assertions.assertEquals((Object)"collate(exchange, header(message, \"max\"))", (Object)code);
        code = parser.parseExpression("${messageHistory}");
        Assertions.assertEquals((Object)"messageHistory(exchange, true)", (Object)code);
        code = parser.parseExpression("${messageHistory(false)}");
        Assertions.assertEquals((Object)"messageHistory(exchange, false)", (Object)code);
    }

    @Test
    public void testType() {
        CSimpleExpressionParser parser = new CSimpleExpressionParser();
        String code = parser.parseExpression("${type:org.apache.camel.Exchange.CONTENT_TYPE}");
        Assertions.assertEquals((Object)"type(exchange, org.apache.camel.Exchange.class, \"CONTENT_TYPE\")", (Object)code);
        code = parser.parseExpression("${type:org.apache.camel.Exchange.FILE_NAME}");
        Assertions.assertEquals((Object)"type(exchange, org.apache.camel.Exchange.class, \"FILE_NAME\")", (Object)code);
        code = parser.parseExpression("${type:org.apache.camel.ExchangePattern.InOut}");
        Assertions.assertEquals((Object)"type(exchange, org.apache.camel.ExchangePattern.class, \"InOut\")", (Object)code);
    }

    @Test
    public void testRef() {
        CSimpleExpressionParser parser = new CSimpleExpressionParser();
        String code = parser.parseExpression("${ref:myUser}");
        Assertions.assertEquals((Object)"ref(exchange, \"myUser\")", (Object)code);
    }

    @Test
    public void testProperties() {
        CSimpleExpressionParser parser = new CSimpleExpressionParser();
        String code = parser.parseExpression("${properties:greeting}");
        Assertions.assertEquals((Object)"properties(exchange, \"greeting\")", (Object)code);
        code = parser.parseExpression("${properties:greeting:hi}");
        Assertions.assertEquals((Object)"properties(exchange, \"greeting\", \"hi\")", (Object)code);
    }

    @Test
    public void testBean() {
        CSimpleExpressionParser parser = new CSimpleExpressionParser();
        String code = parser.parseExpression("${bean:foo}");
        Assertions.assertEquals((Object)"bean(exchange, bean, \"foo\", null, null)", (Object)code);
        code = parser.parseExpression("${bean:foo?method=bar}");
        Assertions.assertEquals((Object)"bean(exchange, bean, \"foo\", \"bar\", null)", (Object)code);
        code = parser.parseExpression("${bean:foo?method=bar(123, true)}");
        Assertions.assertEquals((Object)"bean(exchange, bean, \"foo\", \"bar(123, true)\", null)", (Object)code);
        code = parser.parseExpression("${bean:foo::bar}");
        Assertions.assertEquals((Object)"bean(exchange, bean, \"foo\", \"bar\", null)", (Object)code);
        code = parser.parseExpression("${bean:foo?method=bar&scope=Prototype}");
        Assertions.assertEquals((Object)"bean(exchange, bean, \"foo\", \"bar\", \"Prototype\")", (Object)code);
    }

    @Test
    public void testDateWithTimezone() {
        CSimpleExpressionParser parser = new CSimpleExpressionParser();
        String code = parser.parseExpression("${date-with-timezone:header.birthday:GMT+8:yyyy-MM-dd'T'HH:mm:ss:SSS}");
        Assertions.assertEquals((Object)"date(exchange, \"header.birthday\", \"GMT+8\", \"yyyy-MM-dd'T'HH:mm:ss:SSS\")", (Object)code);
    }

    @Test
    public void testDate() {
        CSimpleExpressionParser parser = new CSimpleExpressionParser();
        String code = parser.parseExpression("${date:now:hh:mm:ss a}");
        Assertions.assertEquals((Object)"date(exchange, \"now\", null, \"hh:mm:ss a\")", (Object)code);
        code = parser.parseExpression("${date:now+60s}");
        Assertions.assertEquals((Object)"date(exchange, \"now+60s\")", (Object)code);
    }

    @Test
    public void testFile() {
        CSimpleExpressionParser parser = new CSimpleExpressionParser();
        String code = parser.parseExpression("${file:name}");
        Assertions.assertEquals((Object)"fileName(message)", (Object)code);
        code = parser.parseExpression("${file:length}");
        Assertions.assertEquals((Object)"fileSize(message)", (Object)code);
    }

    @Test
    public void testExchange() {
        CSimpleExpressionParser parser = new CSimpleExpressionParser();
        String code = parser.parseExpression("${exchange.pattern}");
        Assertions.assertEquals((Object)"exchange.getPattern()", (Object)code);
    }

    @Test
    public void testExchangeProperty() {
        CSimpleExpressionParser parser = new CSimpleExpressionParser();
        String code = parser.parseExpression("Hello ${exchangeProperty.foo}");
        Assertions.assertEquals((Object)"\"Hello \" + exchangeProperty(exchange, \"foo\")", (Object)code);
        code = parser.parseExpression("Hello ${exchangePropertyAs(foo, \"com.foo.MyUser\").firstName}");
        Assertions.assertEquals((Object)"\"Hello \" + exchangePropertyAs(exchange, \"foo\", com.foo.MyUser.class).getFirstName()", (Object)code);
    }

    @Test
    public void testException() {
        CSimpleExpressionParser parser = new CSimpleExpressionParser();
        String code = parser.parseExpression("${exception}");
        Assertions.assertEquals((Object)"exception(exchange)", (Object)code);
        code = parser.parseExpression("${exception.cause}");
        Assertions.assertEquals((Object)"exception(exchange).getCause()", (Object)code);
        code = parser.parseExpression("${exceptionAs(com.foo.MyException).errorCode}");
        Assertions.assertEquals((Object)"exceptionAs(exchange, com.foo.MyException.class).getErrorCode()", (Object)code);
    }
}

