/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import javax.xml.xpath.XPathConstants;
import org.apache.camel.CamelContext;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.language.xpath.XPathLanguage;
import org.apache.camel.spi.Language;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XPathTest
extends LanguageTestSupport {
    @Test
    public void testExpressions() {
        this.assertExpression("in:body()", "<hello id='m123'>world!</hello>");
        this.assertExpression("in:header('foo')", "abc");
        this.assertExpression("$foo", "abc");
    }

    @Test
    public void testPredicates() {
        this.assertPredicate("in:header('foo') = 'abc'");
        this.assertPredicate("$foo = 'abc'");
        this.assertPredicate("$foo = 'bar'", false);
    }

    @Test
    public void testNormalXPathExpression() {
        this.assertExpression("hello", "world!");
        this.assertExpression("hello/text()", "world!");
        this.assertExpression("hello/@id", "m123");
    }

    @Override
    protected String getLanguageName() {
        return "xpath";
    }

    @Override
    protected Language assertResolveLanguage(String languageName) {
        XPathLanguage answer = new XPathLanguage();
        answer.setCamelContext((CamelContext)this.context);
        answer.setResultQName(XPathConstants.STRING);
        Assertions.assertEquals((Object)XPathConstants.STRING, (Object)answer.getResultQName());
        return answer;
    }
}

