/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XPathLanguageSingleNodeListTest
extends ContextTestSupport {
    private static final String XML_INPUT_SINGLE = "<root><name>Raul</name><surname>Kripalani</surname></root>";
    private static final String XML_INPUT_MULTIPLE = "<root><name>Raul</name><name>Raul</name><surname>Kripalani</surname></root>";

    @Test
    public void testSingleNodeList() throws Exception {
        this.getMockEndpoint("mock:found").expectedMessageCount(1);
        this.getMockEndpoint("mock:found").setResultWaitTime(500L);
        this.getMockEndpoint("mock:notfound").expectedMessageCount(0);
        this.getMockEndpoint("mock:notfound").setResultWaitTime(500L);
        this.template.requestBody("direct:doTest", (Object)XML_INPUT_SINGLE, String.class);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMultipleNodeList() throws Exception {
        this.getMockEndpoint("mock:found").expectedMessageCount(0);
        this.getMockEndpoint("mock:found").setResultWaitTime(500L);
        this.getMockEndpoint("mock:notfound").expectedMessageCount(0);
        this.getMockEndpoint("mock:notfound").setResultWaitTime(500L);
        CamelExecutionException ex = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.requestBody("direct:doTest", (Object)XML_INPUT_MULTIPLE, String.class), (String)"NoTypeConversionAvailableException expected");
        Assertions.assertEquals(RuntimeCamelException.class, ex.getCause().getClass());
        Assertions.assertEquals(NoTypeConversionAvailableException.class, ex.getCause().getCause().getClass());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ProcessorDefinition)this.from("direct:doTest").transform().xpath("/root/name")).choice().when().xpath("/name")).to("mock:found")).otherwise().to("mock:notfound");
            }
        };
    }
}

