/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XPathLanguageEndpointTest
extends ContextTestSupport {
    @Test
    public void testXPath() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"<foo>Hello World</foo>");
        this.assertMockEndpointsSatisfied();
        QName qn = (QName)this.context.getTypeConverter().convertTo(QName.class, (Object)"NODESET");
        Assertions.assertEquals((Object)XPathConstants.NODESET, (Object)qn);
        qn = (QName)this.context.getTypeConverter().convertTo(QName.class, (Object)"nodeset");
        Assertions.assertEquals((Object)XPathConstants.NODESET, (Object)qn);
        qn = (QName)this.context.getTypeConverter().convertTo(QName.class, (Object)"BOOLEAN");
        Assertions.assertEquals((Object)XPathConstants.BOOLEAN, (Object)qn);
        qn = (QName)this.context.getTypeConverter().convertTo(QName.class, (Object)"boolean");
        Assertions.assertEquals((Object)XPathConstants.BOOLEAN, (Object)qn);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").setHeader("CamelLanguageScript", (Expression)this.constant("/foo/text()"))).to("language:xpath")).to("mock:result");
            }
        };
    }
}

