/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.NodeList;

public class XPathFunctionTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;
    protected MockEndpoint end;

    @Test
    public void testCheckHeader() throws Exception {
        String body = "<one/>";
        this.x.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.y, this.z});
        this.sendMessage("bar", body);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testCheckBody() throws Exception {
        String body = "<two/>";
        this.y.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.x, this.z});
        this.sendMessage("cheese", body);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSetXpathProperty() throws Exception {
        String body = "<soapenv:Body xmlns:ns=\"http://myNamespace\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"><ns:Addresses> <Address>address1</Address> <Address>address2</Address> <Address>address3</Address> <Address>address4</Address> </ns:Addresses> </soapenv:Body>";
        this.end.reset();
        this.end.expectedMessageCount(1);
        this.template.sendBody("direct:setProperty", (Object)body);
        this.assertMockEndpointsSatisfied();
        Exchange exchange = (Exchange)this.end.getExchanges().get(0);
        NodeList nodeList = (NodeList)exchange.getProperty("Addresses", NodeList.class);
        Assertions.assertNotNull((Object)nodeList, (String)"The node list should not be null");
    }

    protected void sendMessage(Object headerValue, Object body) {
        this.template.sendBodyAndHeader("direct:start", body, "foo", headerValue);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
        this.end = this.getMockEndpoint("mock:end");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().xpath("in:header('foo') = 'bar'")).to("mock:x")).when().xpath("in:body() = '<two/>'")).to("mock:y")).otherwise().to("mock:z");
                ((ProcessorDefinition)this.from("direct:setProperty").setProperty("Addresses").xpath("//Address", NodeList.class)).to("mock:end");
            }
        };
    }
}

