/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Test;

public class XPathFromFileExceptionTest
extends ContextTestSupport {
    @Test
    public void testXPathFromFileExceptionOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"<hello>world!</hello>", "CamelFileName", (Object)"hello.xml");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        XPathFromFileExceptionTest.assertFileNotExists(this.testFile("hello.xml"));
        XPathFromFileExceptionTest.assertFileExists(this.testFile("ok/hello.xml"));
    }

    @Test
    public void testXPathFromFileExceptionFail() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"<hello>world!</hello", "CamelFileName", (Object)"hello2.xml");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        XPathFromFileExceptionTest.assertFileNotExists(this.testFile("hello2.xml"));
        XPathFromFileExceptionTest.assertFileExists(this.testFile("error/hello2.xml"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((OnExceptionDefinition)this.from(XPathFromFileExceptionTest.this.fileUri("?initialDelay=0&delay=10&moveFailed=error&move=ok")).onException(Exception.class).to("mock:error")).end().choice().when().xpath("/hello")).to("mock:result")).end();
            }
        };
    }
}

