/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Test;

public class XPathAnotherRouteConcurrentTest
extends ContextTestSupport {
    @Test
    public void testConcurrent() throws Exception {
        this.doSendMessages(100, 10);
    }

    private void doSendMessages(int files, int poolSize) throws Exception {
        this.getMockEndpoint("mock:claus").expectedMessageCount(files / 2);
        this.getMockEndpoint("mock:james").expectedMessageCount(files / 2);
        this.getMockEndpoint("mock:claus").expectsNoDuplicates((Expression)XPathAnotherRouteConcurrentTest.body());
        this.getMockEndpoint("mock:james").expectsNoDuplicates((Expression)XPathAnotherRouteConcurrentTest.body());
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        ExecutorService executor = Executors.newFixedThreadPool(poolSize);
        int i = 0;
        while (i < files) {
            final int index = i++;
            executor.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    if (index % 2 == 0) {
                        XPathAnotherRouteConcurrentTest.this.template.sendBody("seda:foo", (Object)XPathAnotherRouteConcurrentTest.this.createXmlBody(index, "Claus"));
                    } else {
                        XPathAnotherRouteConcurrentTest.this.template.sendBody("seda:foo", (Object)XPathAnotherRouteConcurrentTest.this.createXmlBody(index, "James"));
                    }
                    return null;
                }
            });
        }
        this.assertMockEndpointsSatisfied();
        executor.shutdown();
    }

    private String createXmlBody(int index, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("<persons>\n");
        for (int i = 0; i < 100; ++i) {
            sb.append("<person>");
            sb.append("<id>").append(index).append("-").append(i).append("</id>");
            sb.append("<name>");
            if (i == 95) {
                sb.append(name);
            } else {
                sb.append("Foo");
            }
            sb.append("</name>");
            sb.append("</person>'\n");
        }
        sb.append("\n</persons>");
        return sb.toString();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("seda:foo?concurrentConsumers=10").choice().when().xpath("/persons/person/name = 'Claus'")).to("mock:claus")).when().xpath("/persons/person/name = 'James'")).to("mock:james")).otherwise().to("mock:other")).end();
            }
        };
    }
}

