/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.util.Map;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.language.variable.VariableLanguage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VariableTest
extends LanguageTestSupport {
    @Test
    public void testVariableExpressions() {
        this.exchange.setVariable("varFoo", (Object)"abc");
        this.assertExpression("varFoo", "abc");
    }

    @Test
    public void testPredicates() {
        this.context.setVariable("varFoo", (Object)true);
        this.assertPredicate("global:varFoo");
        this.exchange.setVariable("varLocalFoo", (Object)false);
        this.assertPredicate("varLocal", false);
    }

    @Test
    public void testVariableHeaders() {
        this.exchange.removeVariable("cheese");
        this.exchange.setVariable("header:myKey.foo", (Object)"abc");
        this.exchange.setVariable("header:myKey.bar", (Object)123);
        this.exchange.setVariable("myOtherKey", (Object)"Hello Again");
        Assertions.assertEquals((Object)"abc", (Object)this.exchange.getVariable("header:myKey.foo"));
        Assertions.assertEquals((Object)123, (Object)this.exchange.getVariable("header:myKey.bar"));
        Map map = (Map)this.exchange.getVariable("header:myKey", Map.class);
        Assertions.assertNotNull((Object)map);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((Object)"abc", map.get("foo"));
        Assertions.assertEquals((Object)123, map.get("bar"));
        map = this.exchange.getVariables();
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertEquals((Object)"Hello Again", map.get("myOtherKey"));
        Assertions.assertEquals((Object)"abc", map.get("header:myKey.foo"));
        Assertions.assertEquals((Object)123, map.get("header:myKey.bar"));
        this.exchange.removeVariable("header:myKey");
        map = this.exchange.getVariables();
        Assertions.assertEquals((int)1, (int)map.size());
    }

    @Test
    public void testInvalidHeaderKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.exchange.getVariable("header:"));
    }

    @Test
    public void testSingleton() {
        VariableLanguage prop = new VariableLanguage();
        Assertions.assertTrue((boolean)prop.isSingleton());
    }

    @Override
    protected String getLanguageName() {
        return "variable";
    }
}

