/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.language.tokenizer.TokenizeLanguage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TokenizerTest
extends ExchangeTestSupport {
    Expression tokenize(String token) {
        return this.tokenize(token, false);
    }

    Expression tokenize(String token, boolean regex) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setCamelContext((CamelContext)this.context);
        return language.createExpression(null, new Object[]{null, null, token, null, null, null, regex});
    }

    Expression tokenize(String headerName, String token) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setCamelContext((CamelContext)this.context);
        return language.createExpression(null, new Object[]{null, "header:" + headerName, token});
    }

    Expression tokenizePair(String startToken, String endToken, boolean includeTokens) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setCamelContext((CamelContext)this.context);
        return language.createExpression(null, new Object[]{null, null, startToken, endToken, null, null, null, null, includeTokens});
    }

    Expression tokenizeXML(String tagName, String inheritNamespaceTagName) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setCamelContext((CamelContext)this.context);
        return language.createExpression(null, new Object[]{null, null, tagName, null, inheritNamespaceTagName, null, null, true});
    }

    @Override
    protected void populateExchange(Exchange exchange) {
        super.populateExchange(exchange);
        exchange.getIn().setHeader("names", (Object)"Claus,James,Willem");
    }

    @Test
    public void testTokenizeHeaderWithStringConstructor() {
        List names = (List)this.tokenize("names", ",").evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)3, (int)names.size());
        Assertions.assertEquals((Object)"Claus", names.get(0));
        Assertions.assertEquals((Object)"James", names.get(1));
        Assertions.assertEquals((Object)"Willem", names.get(2));
    }

    @Test
    public void testTokenizeHeader() {
        Expression exp = this.tokenize("names", ",");
        exp.init((CamelContext)this.context);
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)3, (int)names.size());
        Assertions.assertEquals((Object)"Claus", names.get(0));
        Assertions.assertEquals((Object)"James", names.get(1));
        Assertions.assertEquals((Object)"Willem", names.get(2));
    }

    @Test
    public void testTokenizeBody() {
        Expression exp = this.tokenize(",");
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"Hadrian,Charles");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)2, (int)names.size());
        Assertions.assertEquals((Object)"Hadrian", names.get(0));
        Assertions.assertEquals((Object)"Charles", names.get(1));
    }

    @Test
    public void testTokenizeBodyRegEx() {
        Expression exp = this.tokenize("(\\W+)\\s*", true);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"The little fox");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)3, (int)names.size());
        Assertions.assertEquals((Object)"The", names.get(0));
        Assertions.assertEquals((Object)"little", names.get(1));
        Assertions.assertEquals((Object)"fox", names.get(2));
    }

    @Test
    public void testTokenizeHeaderRegEx() {
        Expression exp = this.tokenize("quote", "(\\W+)\\s*");
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setHeader("quote", (Object)"Camel rocks");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)2, (int)names.size());
        Assertions.assertEquals((Object)"Camel", names.get(0));
        Assertions.assertEquals((Object)"rocks", names.get(1));
    }

    @Test
    public void testTokenizeManualConfiguration() {
        TokenizeLanguage lan = new TokenizeLanguage();
        lan.setCamelContext((CamelContext)this.context);
        Expression exp = lan.createExpression(null, new Object[]{null, "header:names", ","});
        exp.init((CamelContext)this.context);
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)3, (int)names.size());
        Assertions.assertEquals((Object)"Claus", names.get(0));
        Assertions.assertEquals((Object)"James", names.get(1));
        Assertions.assertEquals((Object)"Willem", names.get(2));
    }

    @Test
    public void testTokenizePairSpecial() {
        Expression exp = this.tokenizePair("!", "@", false);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"2011-11-11\n!James@!Claus@\n2 records");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)2, (int)names.size());
        Assertions.assertEquals((Object)"James", names.get(0));
        Assertions.assertEquals((Object)"Claus", names.get(1));
    }

    @Test
    public void testTokenizePair() {
        Expression exp = this.tokenizePair("[START]", "[END]", false);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"2011-11-11\n[START]James[END]\n[START]Claus[END]\n2 records");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)2, (int)names.size());
        Assertions.assertEquals((Object)"James", names.get(0));
        Assertions.assertEquals((Object)"Claus", names.get(1));
    }

    @Test
    public void testTokenizePairSimple() {
        Expression exp = this.tokenizePair("${header.foo}", "${header.bar}", false);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setHeader("foo", (Object)"[START]");
        this.exchange.getIn().setHeader("bar", (Object)"[END]");
        this.exchange.getIn().setBody((Object)"2011-11-11\n[START]James[END]\n[START]Claus[END]\n2 records");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)2, (int)names.size());
        Assertions.assertEquals((Object)"James", names.get(0));
        Assertions.assertEquals((Object)"Claus", names.get(1));
    }

    @Test
    public void testTokenizePairIncludeTokens() {
        Expression exp = this.tokenizePair("[START]", "[END]", true);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"2011-11-11\n[START]James[END]\n[START]Claus[END]\n2 records");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)2, (int)names.size());
        Assertions.assertEquals((Object)"[START]James[END]", names.get(0));
        Assertions.assertEquals((Object)"[START]Claus[END]", names.get(1));
    }

    @Test
    public void testTokenizeXMLPair() {
        Expression exp = this.tokenizeXML("<person>", null);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<persons><person>James</person><person>Claus</person><person>Jonathan</person><person>Hadrian</person></persons>");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)4, (int)names.size());
        Assertions.assertEquals((Object)"<person>James</person>", names.get(0));
        Assertions.assertEquals((Object)"<person>Claus</person>", names.get(1));
        Assertions.assertEquals((Object)"<person>Jonathan</person>", names.get(2));
        Assertions.assertEquals((Object)"<person>Hadrian</person>", names.get(3));
    }

    @Test
    public void testTokenizeXMLPairSimple() {
        Expression exp = this.tokenizeXML("${header.foo}", null);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setHeader("foo", (Object)"<person>");
        this.exchange.getIn().setBody((Object)"<persons><person>James</person><person>Claus</person><person>Jonathan</person><person>Hadrian</person></persons>");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)4, (int)names.size());
        Assertions.assertEquals((Object)"<person>James</person>", names.get(0));
        Assertions.assertEquals((Object)"<person>Claus</person>", names.get(1));
        Assertions.assertEquals((Object)"<person>Jonathan</person>", names.get(2));
        Assertions.assertEquals((Object)"<person>Hadrian</person>", names.get(3));
    }

    @Test
    public void testTokenizeXMLPairNoXMLTag() {
        Expression exp = this.tokenizeXML("person", null);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<persons><person>James</person><person>Claus</person><person>Jonathan</person><person>Hadrian</person></persons>");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)4, (int)names.size());
        Assertions.assertEquals((Object)"<person>James</person>", names.get(0));
        Assertions.assertEquals((Object)"<person>Claus</person>", names.get(1));
        Assertions.assertEquals((Object)"<person>Jonathan</person>", names.get(2));
        Assertions.assertEquals((Object)"<person>Hadrian</person>", names.get(3));
    }

    @Test
    public void testTokenizeXMLPairWithNoise() {
        Expression exp = this.tokenizeXML("<person>", null);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><!-- bla bla --><persons>\n<person>James</person>\n<person>Claus</person>\n<!-- more bla bla --><person>Jonathan</person>\n<person>Hadrian</person>\n</persons>   ");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)4, (int)names.size());
        Assertions.assertEquals((Object)"<person>James</person>", names.get(0));
        Assertions.assertEquals((Object)"<person>Claus</person>", names.get(1));
        Assertions.assertEquals((Object)"<person>Jonathan</person>", names.get(2));
        Assertions.assertEquals((Object)"<person>Hadrian</person>", names.get(3));
    }

    @Test
    public void testTokenizeXMLPairEmpty() {
        Expression exp = this.tokenizeXML("<person>", null);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><!-- bla bla --><persons></persons>   ");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)0, (int)names.size());
    }

    @Test
    public void testTokenizeXMLPairNoData() {
        Expression exp = this.tokenizeXML("<person>", null);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)0, (int)names.size());
    }

    @Test
    public void testTokenizeXMLPairNullData() {
        Expression exp = this.tokenizeXML("<person>", null);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody(null);
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertNull((Object)names);
    }

    @Test
    public void testTokenizeXMLPairWithSimilarChildNames() {
        Expression exp = this.tokenizeXML("Trip", "Trips");
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<?xml version='1.0' encoding='UTF-8'?>\n<Trips>\n<Trip>\n<TripType>\n</TripType>\n</Trip>\n</Trips>");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)1, (int)names.size());
    }

    @Test
    public void testTokenizeXMLPairWithDefaultNamespace() {
        Expression exp = this.tokenizeXML("<person>", "<persons>");
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><persons xmlns=\"http:acme.com/persons\">\n<person>James</person>\n<person>Claus</person>\n<person>Jonathan</person>\n<person>Hadrian</person>\n</persons>\n");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)4, (int)names.size());
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">James</person>", names.get(0));
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Claus</person>", names.get(1));
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Jonathan</person>", names.get(2));
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Hadrian</person>", names.get(3));
    }

    @Test
    public void testTokenizeXMLPairWithDefaultNamespaceNotInherit() {
        Expression exp = this.tokenizeXML("<person>", null);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><persons xmlns=\"http:acme.com/persons\">\n<person>James</person>\n<person>Claus</person>\n<person>Jonathan</person>\n<person>Hadrian</person>\n</persons>\n");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)4, (int)names.size());
        Assertions.assertEquals((Object)"<person>James</person>", names.get(0));
        Assertions.assertEquals((Object)"<person>Claus</person>", names.get(1));
        Assertions.assertEquals((Object)"<person>Jonathan</person>", names.get(2));
        Assertions.assertEquals((Object)"<person>Hadrian</person>", names.get(3));
    }

    @Test
    public void testTokenizeXMLPairWithDefaultAndFooNamespace() {
        Expression exp = this.tokenizeXML("<person>", "<persons>");
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><persons xmlns=\"http:acme.com/persons\" xmlns:foo=\"http:foo.com\">\n<person>James</person>\n<person>Claus</person>\n<person>Jonathan</person>\n<person>Hadrian</person>\n</persons>\n");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)4, (int)names.size());
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\" xmlns:foo=\"http:foo.com\">James</person>", names.get(0));
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\" xmlns:foo=\"http:foo.com\">Claus</person>", names.get(1));
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\" xmlns:foo=\"http:foo.com\">Jonathan</person>", names.get(2));
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\" xmlns:foo=\"http:foo.com\">Hadrian</person>", names.get(3));
    }

    @Test
    public void testTokenizeXMLPairWithLocalNamespace() {
        Expression exp = this.tokenizeXML("<person>", null);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><persons>\n<person xmlns=\"http:acme.com/persons\">James</person>\n<person xmlns=\"http:acme.com/persons\">Claus</person>\n<person xmlns=\"http:acme.com/persons\">Jonathan</person>\n<person xmlns=\"http:acme.com/persons\">Hadrian</person>\n</persons>\n");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)4, (int)names.size());
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">James</person>", names.get(0));
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Claus</person>", names.get(1));
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Jonathan</person>", names.get(2));
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Hadrian</person>", names.get(3));
    }

    @Test
    public void testTokenizeXMLPairWithLocalAndInheritedNamespace() {
        Expression exp = this.tokenizeXML("<person>", "<persons>");
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><persons xmlns=\"http:acme.com/persons\">\n<person xmlns:foo=\"http:foo.com\">James</person>\n<person>Claus</person>\n<person>Jonathan</person>\n<person xmlns:bar=\"http:bar.com\">Hadrian</person>\n</persons>\n");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)4, (int)names.size());
        Assertions.assertEquals((Object)"<person xmlns:foo=\"http:foo.com\" xmlns=\"http:acme.com/persons\">James</person>", names.get(0));
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Claus</person>", names.get(1));
        Assertions.assertEquals((Object)"<person xmlns=\"http:acme.com/persons\">Jonathan</person>", names.get(2));
        Assertions.assertEquals((Object)"<person xmlns:bar=\"http:bar.com\" xmlns=\"http:acme.com/persons\">Hadrian</person>", names.get(3));
    }

    @Test
    public void testTokenizeXMLPairWithLocalAndNotInheritedNamespace() {
        Expression exp = this.tokenizeXML("<person>", null);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<?xml version=\"1.0\"?><persons xmlns=\"http:acme.com/persons\">\n<person xmlns:foo=\"http:foo.com\">James</person>\n<person>Claus</person>\n<person>Jonathan</person>\n<person xmlns:bar=\"http:bar.com\">Hadrian</person>\n</persons>\n");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)4, (int)names.size());
        Assertions.assertEquals((Object)"<person xmlns:foo=\"http:foo.com\">James</person>", names.get(0));
        Assertions.assertEquals((Object)"<person>Claus</person>", names.get(1));
        Assertions.assertEquals((Object)"<person>Jonathan</person>", names.get(2));
        Assertions.assertEquals((Object)"<person xmlns:bar=\"http:bar.com\">Hadrian</person>", names.get(3));
    }

    @Test
    public void testTokenizeXMLPairWithAttributes() {
        Expression exp = this.tokenizeXML("<person>", null);
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<persons><person id=\"1\">James</person><person id=\"2\">Claus</person><person id=\"3\">Jonathan</person><person id=\"4\">Hadrian</person></persons>");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)4, (int)names.size());
        Assertions.assertEquals((Object)"<person id=\"1\">James</person>", names.get(0));
        Assertions.assertEquals((Object)"<person id=\"2\">Claus</person>", names.get(1));
        Assertions.assertEquals((Object)"<person id=\"3\">Jonathan</person>", names.get(2));
        Assertions.assertEquals((Object)"<person id=\"4\">Hadrian</person>", names.get(3));
    }

    @Test
    public void testTokenizeXMLPairWithAttributesInheritNamespace() {
        Expression exp = this.tokenizeXML("<person>", "<persons>");
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<persons xmlns=\"http:acme.com/persons\"><person id=\"1\">James</person><person id=\"2\">Claus</person><person id=\"3\">Jonathan</person><person id=\"4\">Hadrian</person></persons>");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)4, (int)names.size());
        Assertions.assertEquals((Object)"<person id=\"1\" xmlns=\"http:acme.com/persons\">James</person>", names.get(0));
        Assertions.assertEquals((Object)"<person id=\"2\" xmlns=\"http:acme.com/persons\">Claus</person>", names.get(1));
        Assertions.assertEquals((Object)"<person id=\"3\" xmlns=\"http:acme.com/persons\">Jonathan</person>", names.get(2));
        Assertions.assertEquals((Object)"<person id=\"4\" xmlns=\"http:acme.com/persons\">Hadrian</person>", names.get(3));
    }

    @Test
    public void testTokenizeXMLPairWithAttributes2InheritNamespace() {
        Expression exp = this.tokenizeXML("<person>", "<persons>");
        exp.init((CamelContext)this.context);
        this.exchange.getIn().setBody((Object)"<persons riders=\"true\" xmlns=\"http:acme.com/persons\"><person id=\"1\">James</person><person id=\"2\">Claus</person><person id=\"3\">Jonathan</person><person id=\"4\">Hadrian</person></persons>");
        List names = (List)exp.evaluate(this.exchange, List.class);
        Assertions.assertEquals((int)4, (int)names.size());
        Assertions.assertEquals((Object)"<person id=\"1\" xmlns=\"http:acme.com/persons\">James</person>", names.get(0));
        Assertions.assertEquals((Object)"<person id=\"2\" xmlns=\"http:acme.com/persons\">Claus</person>", names.get(1));
        Assertions.assertEquals((Object)"<person id=\"3\" xmlns=\"http:acme.com/persons\">Jonathan</person>", names.get(2));
        Assertions.assertEquals((Object)"<person id=\"4\" xmlns=\"http:acme.com/persons\">Hadrian</person>", names.get(3));
    }
}

