/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.SplitDefinition;
import org.junit.jupiter.api.Test;

public class TokenXMLPairNamespaceSplitTest
extends ContextTestSupport {
    @Test
    public void testTokenXMLPair() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMessageCount(3);
        ((MockValueBuilder)mock.message(0).body()).isEqualTo((Object)"<order id=\"1\" xmlns=\"http:acme.com\">Camel in Action</order>");
        ((MockValueBuilder)mock.message(1).body()).isEqualTo((Object)"<order id=\"2\" xmlns=\"http:acme.com\">ActiveMQ in Action</order>");
        ((MockValueBuilder)mock.message(2).body()).isEqualTo((Object)"<order id=\"3\" xmlns=\"http:acme.com\">DSL in Action</order>");
        String body = this.createBody();
        this.template.sendBody("direct:pair", (Object)body);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTokenXMLPair2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMessageCount(3);
        ((MockValueBuilder)mock.message(0).body()).isEqualTo((Object)"<order id=\"1\" xmlns=\"http:acme.com\">Camel in Action</order>");
        ((MockValueBuilder)mock.message(1).body()).isEqualTo((Object)"<order id=\"2\" xmlns=\"http:acme.com\">ActiveMQ in Action</order>");
        ((MockValueBuilder)mock.message(2).body()).isEqualTo((Object)"<order id=\"3\" xmlns=\"http:acme.com\">DSL in Action</order>");
        String body = this.createBody();
        this.template.sendBody("direct:pair2", (Object)body);
        this.assertMockEndpointsSatisfied();
    }

    protected String createBody() {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\"?>\n");
        sb.append("<orders xmlns=\"http:acme.com\">\n");
        sb.append("  <order id=\"1\">Camel in Action</order>\n");
        sb.append("  <order id=\"2\">ActiveMQ in Action</order>\n");
        sb.append("  <order id=\"3\">DSL in Action</order>\n");
        sb.append("</orders>");
        return sb.toString();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:pair").split().tokenizeXML("order", "orders")).to("mock:split");
                this.from("direct:pair2").split((Expression)this.body().tokenizeXML("order", "orders")).to("mock:split");
            }
        };
    }
}

