/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.SplitDefinition;
import org.junit.jupiter.api.Test;

public class TokenXMLPairNamespaceSplitChildNamespaceTest
extends ContextTestSupport {
    @Test
    public void testTokenXMLPair() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMessageCount(4);
        ((MockValueBuilder)mock.message(0).body()).isEqualTo((Object)"<order id=\"1\" xmlns=\"http:acme.com\" xmlns:foo=\"http:foo.com\">Camel in Action</order>");
        ((MockValueBuilder)mock.message(1).body()).isEqualTo((Object)"<order id=\"2\" xmlns=\"http:acme.com\" xmlns:foo=\"http:foo.com\">ActiveMQ in Action</order>");
        ((MockValueBuilder)mock.message(2).body()).isEqualTo((Object)"<order id=\"3\" xmlns=\"http:acme.com\" xmlns:foo=\"http:foo.com\">DSL in Action</order>");
        ((MockValueBuilder)mock.message(3).body()).isEqualTo((Object)"<order id=\"4\" xmlns:foo=\"http:foo.com\" xmlns=\"http:acme.com\">DSL in Action</order>");
        String body = this.createBody();
        this.template.sendBodyAndHeader(this.fileUri("pair"), (Object)body, "CamelFileName", (Object)"orders.xml");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTokenXMLPair2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMessageCount(4);
        ((MockValueBuilder)mock.message(0).body()).isEqualTo((Object)"<order id=\"1\" xmlns=\"http:acme.com\" xmlns:foo=\"http:foo.com\">Camel in Action</order>");
        ((MockValueBuilder)mock.message(1).body()).isEqualTo((Object)"<order id=\"2\" xmlns=\"http:acme.com\" xmlns:foo=\"http:foo.com\">ActiveMQ in Action</order>");
        ((MockValueBuilder)mock.message(2).body()).isEqualTo((Object)"<order id=\"3\" xmlns=\"http:acme.com\" xmlns:foo=\"http:foo.com\">DSL in Action</order>");
        ((MockValueBuilder)mock.message(3).body()).isEqualTo((Object)"<order id=\"4\" xmlns:foo=\"http:foo.com\" xmlns=\"http:acme.com\">DSL in Action</order>");
        String body = this.createBody();
        this.template.sendBodyAndHeader(this.fileUri("pair2"), (Object)body, "CamelFileName", (Object)"orders.xml");
        this.assertMockEndpointsSatisfied();
    }

    protected String createBody() {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\"?>\n");
        sb.append("<orders xmlns=\"http:acme.com\"\n");
        sb.append("        xmlns:foo=\"http:foo.com\">\n");
        sb.append("  <order id=\"1\" xmlns=\"http:acme.com\">Camel in Action</order>\n");
        sb.append("  <order id=\"2\"");
        sb.append(" xmlns=\"http:acme.com\">ActiveMQ in Action</order>\n");
        sb.append("  <order id=\"3\">DSL in Action</order>\n");
        sb.append("  <order id=\"4\" xmlns:foo=\"http:foo.com\">DSL in Action</order>\n");
        sb.append("</orders>");
        return sb.toString();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from(TokenXMLPairNamespaceSplitChildNamespaceTest.this.fileUri("pair?initialDelay=0&delay=10")).split().tokenizeXML("order", "orders")).to("mock:split");
                this.from(TokenXMLPairNamespaceSplitChildNamespaceTest.this.fileUri("pair2?initialDelay=0&delay=10")).split((Expression)this.body().tokenizeXML("order", "orders")).to("mock:split");
            }
        };
    }
}

