/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.language.TokenXMLPairNamespaceSplitTest;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TokenXMLPairMultiNamespaceSplitTest
extends TokenXMLPairNamespaceSplitTest {
    @Override
    @Test
    public void testTokenXMLPair() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMessageCount(3);
        ((MockValueBuilder)mock.message(0).body()).isEqualTo((Object)"<order id=\"1\" xmlns=\"http:acme.com\" xmlns:foo=\"http:foo.com\">Camel in Action</order>");
        ((MockValueBuilder)mock.message(1).body()).isEqualTo((Object)"<order id=\"2\" xmlns=\"http:acme.com\" xmlns:foo=\"http:foo.com\">ActiveMQ in Action</order>");
        ((MockValueBuilder)mock.message(2).body()).isEqualTo((Object)"<order id=\"3\" xmlns=\"http:acme.com\" xmlns:foo=\"http:foo.com\">DSL in Action</order>");
        String body = this.createBody();
        this.template.sendBody("direct:pair", (Object)body);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @Disabled
    @Test
    public void testTokenXMLPair2() {
    }

    @Override
    protected String createBody() {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\"?>\n");
        sb.append("<orders xmlns=\"http:acme.com\" xmlns:foo=\"http:foo.com\">\n");
        sb.append("  <order id=\"1\">Camel in Action</order>\n");
        sb.append("  <order id=\"2\">ActiveMQ in Action</order>\n");
        sb.append("  <order id=\"3\">DSL in Action</order>\n");
        sb.append("</orders>");
        return sb.toString();
    }
}

