/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.junit.jupiter.api.Test;

public class SimpleXPathTransformTest
extends ContextTestSupport {
    private static final String EXPECTED = "<user>\n  <rool>123</rool>\n  <country>sweden</country>\n  <fullname>scott</fullname>\n</user>";

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").transform().simple("<user>\n  <rool>${xpath(/order/@id)}</rool>\n  <country>${xpath(/order/address/co/text())}</country>\n  <fullname>${xpath(/order/first/text())}</fullname>\n</user>")).to("mock:result");
            }
        };
    }

    @Test
    public void testTransform() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{EXPECTED});
        this.template.sendBody("direct:start", (Object)"<order id=\"123\">\n  <item>Brake</item>\n  <first>scott</first>\n  <last>jackson</last>\n  <address>\n    <co>sweden</co>\n    <zip>12345</zip>\n  </address>\n</order>\n");
        MockEndpoint.assertIsSatisfied((CamelContext)this.context);
    }
}

