/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.Exchange;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.ExpressionAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RefTest
extends LanguageTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myExp", (Object)new MyExpression());
        return jndi;
    }

    @Test
    public void testRefExpressions() {
        this.assertExpression("myExp", "Hello World");
    }

    @Test
    public void testRefExpressionsNotFound() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertExpression("foo", "Hello World"), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"Cannot find expression or predicate in registry with ref: foo", (Object)e.getMessage());
    }

    @Test
    public void testRefDynamicExpressions() {
        this.exchange.getMessage().setHeader("foo", (Object)"myExp");
        this.assertExpression("${header.foo}", "Hello World");
    }

    @Test
    public void testRefDynamicExpressionsNotFound() {
        this.exchange.getMessage().setHeader("foo", (Object)"myExp2");
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertExpression("${header.foo}", "Hello World"), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"Cannot find expression or predicate in registry with ref: myExp2", (Object)e.getMessage());
    }

    @Test
    public void testPredicates() {
        this.assertPredicate("myExp");
    }

    @Override
    protected String getLanguageName() {
        return "ref";
    }

    private static class MyExpression
    extends ExpressionAdapter {
        private MyExpression() {
        }

        public Object evaluate(Exchange exchange) {
            return "Hello World";
        }
    }
}

