/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.Exchange;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class RefPredicateTest
extends LanguageTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myPredicate", (Object)new MyPredicate());
        return jndi;
    }

    @Test
    public void testExpression() {
        this.exchange.getIn().setBody((Object)"Hello World");
        this.assertExpression("myPredicate", "true");
        this.exchange.getIn().setBody((Object)"Bye World");
        this.assertExpression("myPredicate", "false");
    }

    @Test
    public void testPredicates() {
        this.exchange.getIn().setBody((Object)"Hello World");
        this.assertPredicate("myPredicate", true);
        this.exchange.getIn().setBody((Object)"Bye World");
        this.assertPredicate("myPredicate", false);
    }

    @Override
    protected String getLanguageName() {
        return "ref";
    }

    private static class MyPredicate
    implements Predicate {
        private MyPredicate() {
        }

        public boolean matches(Exchange exchange) {
            return exchange.getIn().getBody().equals("Hello World");
        }
    }
}

