/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.PropertyInject;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.PropertiesComponent;
import org.junit.jupiter.api.Test;

public class PropertyInjectAnnotationParameterTest
extends ContextTestSupport {
    @Test
    public void testPropertyInjectAnnotationOne() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:one", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testPropertyInjectAnnotationTwo() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"WorldWorldWorld"});
        this.template.sendBody("direct:two", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testPropertyInjectAnnotationThree() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Goodbye World"});
        this.template.sendBody("direct:three", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = context.getPropertiesComponent();
        Properties props = new Properties();
        props.put("greeting", "Hello");
        props.put("times", "3");
        pc.setInitialProperties(props);
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:one").bean(MyBean.class)).to("mock:result");
                ((RouteDefinition)this.from("direct:two").bean(MyCounterBean.class)).to("mock:result");
                ((RouteDefinition)this.from("direct:three").bean(MyOtherBean.class)).to("mock:result");
            }
        };
    }

    public static final class MyCounterBean {
        public String callA(@PropertyInject(value="times") int times, String body) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < times; ++i) {
                sb.append(body);
            }
            return sb.toString();
        }
    }

    public static final class MyOtherBean {
        public String callA(@PropertyInject(value="bye", defaultValue="Goodbye") String bye, String body) {
            return bye + " " + body;
        }
    }

    public static final class MyBean {
        public String callA(@PropertyInject(value="greeting") String greeting, String body) {
            return greeting + " " + body;
        }
    }
}

