/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.IsSingleton;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LanguageServiceTest
extends ContextTestSupport {
    private final MyLanguage my = new MyLanguage();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("my", (Object)this.my);
        return jndi;
    }

    @Test
    public void testLanguageService() {
        MyLanguage myl = (MyLanguage)this.context.resolveLanguage("my");
        Assertions.assertNotNull((Object)((Object)myl));
        Assertions.assertEquals((Object)"Started", (Object)myl.getState());
        Assertions.assertEquals((int)2, (int)this.context.getLanguageNames().size());
        MyLanguage myl2 = (MyLanguage)this.context.resolveLanguage("my");
        Assertions.assertNotNull((Object)((Object)myl2));
        Assertions.assertSame((Object)((Object)myl), (Object)((Object)myl2));
        Assertions.assertEquals((Object)"Started", (Object)myl2.getState());
        Assertions.assertEquals((int)2, (int)this.context.getLanguageNames().size());
        this.context.stop();
        Assertions.assertEquals((Object)"Stopped", (Object)myl.getState());
        Assertions.assertTrue((boolean)this.context.getLanguageNames().isEmpty());
    }

    public static class MyLanguage
    extends ServiceSupport
    implements Language,
    IsSingleton {
        private String state;

        public Predicate createPredicate(String expression) {
            return PredicateBuilder.constant((boolean)true);
        }

        public Expression createExpression(String expression) {
            return ExpressionBuilder.constantExpression((Object)expression);
        }

        public String getState() {
            return this.state;
        }

        protected void doStart() {
            this.state = "Started";
        }

        protected void doStop() {
            this.state = "Stopped";
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

