/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.apache.camel.Exchange;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileLanguageTest
extends LanguageTestSupport {
    private static final String TEST_FILE_NAME_NOEXT_1 = "hello" + String.valueOf(UUID.randomUUID());
    private static final String TEST_FILE_NAME_1 = TEST_FILE_NAME_NOEXT_1 + ".txt";
    private static final String TEST_FILE_NAME_NOEXT_2 = "MyBigFile" + String.valueOf(UUID.randomUUID());
    private static final String TEST_FILE_NAME_2 = TEST_FILE_NAME_NOEXT_2 + ".txt";
    private File file;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("generator", (Object)new MyFileNameGenerator());
        return jndi;
    }

    @Override
    protected String getLanguageName() {
        return "file";
    }

    @Test
    public void testConstantExpression() {
        this.assertExpression(TEST_FILE_NAME_2, TEST_FILE_NAME_2);
    }

    @Test
    public void testMessageId() {
        this.assertExpression("${id}", this.exchange.getIn().getMessageId());
        this.assertExpression("${id}.bak", this.exchange.getIn().getMessageId() + ".bak");
    }

    @Test
    public void testInvalidSyntax() {
        this.assertExpression("${file:onlyname}", this.file.getName());
        ExpressionIllegalSyntaxException e = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("${file:onlyName}", this.file.getName()), (String)"Should have thrown exception");
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Unknown file language syntax: onlyName at location 0"));
    }

    @Test
    public void testFile() {
        this.assertExpression("${file:ext}", "txt");
        this.assertExpression("${file:name.ext}", "txt");
        this.assertExpression("${file:name.ext.single}", "txt");
        this.assertExpression("${file:name}", "test" + File.separator + this.file.getName());
        this.assertExpression("${file:name.noext}", "test" + File.separator + TEST_FILE_NAME_NOEXT_1);
        this.assertExpression("${file:name.noext.single}", "test" + File.separator + TEST_FILE_NAME_NOEXT_1);
        this.assertExpression("${file:onlyname}", this.file.getName());
        this.assertExpression("${file:onlyname.noext}", TEST_FILE_NAME_NOEXT_1);
        this.assertExpression("${file:onlyname.noext.single}", TEST_FILE_NAME_NOEXT_1);
        this.assertExpression("${file:parent}", this.file.getParent());
        this.assertExpression("${file:path}", this.file.getPath());
        this.assertExpression("${file:absolute}", FileUtil.isAbsolute((File)this.file));
        this.assertExpression("${file:absolute.path}", this.file.getAbsolutePath());
        this.assertExpression("${file:length}", this.file.length());
        this.assertExpression("${file:size}", this.file.length());
        Long modified = (Long)this.context.resolveLanguage("simple").createExpression("${file:modified}").evaluate(this.exchange, Long.class);
        Assertions.assertEquals((long)this.file.lastModified(), (long)modified);
    }

    @Test
    public void testFileUsingAlternativeStartToken() {
        this.assertExpression("$simple{file:ext}", "txt");
        this.assertExpression("$simple{file:name.ext}", "txt");
        this.assertExpression("$simple{file:name}", "test" + File.separator + this.file.getName());
        this.assertExpression("$simple{file:name.noext}", "test" + File.separator + TEST_FILE_NAME_NOEXT_1);
        this.assertExpression("$simple{file:onlyname}", this.file.getName());
        this.assertExpression("$simple{file:onlyname.noext}", TEST_FILE_NAME_NOEXT_1);
        this.assertExpression("$simple{file:parent}", this.file.getParent());
        this.assertExpression("$simple{file:path}", this.file.getPath());
        this.assertExpression("$simple{file:absolute}", FileUtil.isAbsolute((File)this.file));
        this.assertExpression("$simple{file:absolute.path}", this.file.getAbsolutePath());
        this.assertExpression("$simple{file:length}", this.file.length());
        this.assertExpression("$simple{file:size}", this.file.length());
        long modified = (Long)this.context.resolveLanguage("simple").createExpression("${file:modified}").evaluate(this.exchange, Long.TYPE);
        Assertions.assertEquals((long)this.file.lastModified(), (long)modified);
    }

    @Test
    public void testDate() {
        String now = new SimpleDateFormat("yyyyMMdd").format(new Date());
        this.assertExpression("backup-${date:now:yyyyMMdd}", "backup-" + now);
        String expected = new SimpleDateFormat("yyyyMMdd").format(new Date(this.file.lastModified()));
        this.assertExpression("backup-${date:file:yyyyMMdd}", "backup-" + expected);
        this.assertExpression("backup-${date:header.birthday:yyyyMMdd}", "backup-19740420");
        this.assertExpression(TEST_FILE_NAME_NOEXT_1 + "-${date:header.special:yyyyMMdd}", TEST_FILE_NAME_NOEXT_1 + "-20080808");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertExpression("nodate-${date:header.xxx:yyyyMMdd}", null), (String)"Should have thrown IllegalArgumentException");
    }

    @Test
    public void testDateUsingAlternativeStartToken() {
        String now = new SimpleDateFormat("yyyyMMdd").format(new Date());
        this.assertExpression("backup-$simple{date:now:yyyyMMdd}", "backup-" + now);
        String expected = new SimpleDateFormat("yyyyMMdd").format(new Date(this.file.lastModified()));
        this.assertExpression("backup-$simple{date:file:yyyyMMdd}", "backup-" + expected);
        this.assertExpression("backup-$simple{date:header.birthday:yyyyMMdd}", "backup-19740420");
        this.assertExpression(TEST_FILE_NAME_NOEXT_1 + "-$simple{date:header.special:yyyyMMdd}", TEST_FILE_NAME_NOEXT_1 + "-20080808");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertExpression("nodate-$simple{date:header.xxx:yyyyMMdd}", null), (String)"Should have thrown IllegalArgumentException");
    }

    @Test
    public void testSimpleAndFile() {
        this.assertExpression("backup-${in.header.foo}-${file:name.noext}.bak", "backup-abc-test" + File.separator + TEST_FILE_NAME_NOEXT_1 + ".bak");
        this.assertExpression("backup-${in.header.foo}-${file:onlyname.noext}.bak", "backup-abc-" + TEST_FILE_NAME_NOEXT_1 + ".bak");
    }

    @Test
    public void testSimpleAndFileAndBean() {
        this.assertExpression("backup-${in.header.foo}-${bean:generator}-${file:name.noext}.bak", "backup-abc-generatorbybean-test" + File.separator + TEST_FILE_NAME_NOEXT_1 + ".bak");
        this.assertExpression("backup-${in.header.foo}-${bean:generator}-${file:onlyname.noext}.bak", "backup-abc-generatorbybean-" + TEST_FILE_NAME_NOEXT_1 + ".bak");
    }

    @Test
    public void testBean() {
        this.assertExpression("backup-${bean:generator}.txt", "backup-generatorbybean.txt");
        this.assertExpression("backup-${bean:generator.generateFilename}.txt", "backup-generatorbybean.txt");
    }

    @Test
    public void testNoEscapeAllowed() {
        this.exchange.getIn().setHeader("CamelFileName", (Object)TEST_FILE_NAME_1);
        this.assertExpression("target\\newdir\\onwindows\\${file:name}", "target\\newdir\\onwindows\\" + TEST_FILE_NAME_1);
    }

    @Test
    public void testFileNameDoubleExtension() {
        this.file = this.testFile("test/" + TEST_FILE_NAME_NOEXT_2 + ".tar.gz").toFile();
        String uri = this.fileUri("?fileExist=Override");
        GenericFile gf = FileConsumer.asGenericFile((String)this.testDirectory().toString(), (File)this.file, null, (boolean)false);
        FileEndpoint endpoint = this.getMandatoryEndpoint(uri, FileEndpoint.class);
        Exchange answer = endpoint.createExchange(gf);
        endpoint.configureMessage(gf, answer.getIn());
        Assertions.assertEquals((Object)(TEST_FILE_NAME_NOEXT_2 + ".tar.gz"), (Object)this.file.getName());
        this.assertExpression(answer, "${file:onlyname}", (Object)(TEST_FILE_NAME_NOEXT_2 + ".tar.gz"));
        this.assertExpression(answer, "${file:ext}", (Object)"tar.gz");
    }

    @Override
    public Exchange createExchange() {
        String uri = "file://" + this.testDirectory().toString() + "?fileExist=Override";
        this.template.sendBodyAndHeader(uri, (Object)"Hello World", "CamelFileName", (Object)("test/" + TEST_FILE_NAME_1));
        this.file = this.testDirectory().resolve("test/" + TEST_FILE_NAME_1).toFile();
        GenericFile gf = FileConsumer.asGenericFile((String)this.testDirectory().toString(), (File)this.file, null, (boolean)false);
        FileEndpoint endpoint = this.getMandatoryEndpoint(uri, FileEndpoint.class);
        Exchange answer = endpoint.createExchange(gf);
        endpoint.configureMessage(gf, answer.getIn());
        Calendar cal = Calendar.getInstance();
        cal.set(1974, 3, 20);
        answer.getMessage().setHeader("birthday", (Object)cal.getTime());
        cal.set(2008, 7, 8);
        answer.getMessage().setHeader("special", (Object)cal.getTime());
        return answer;
    }

    @Test
    public void testIllegalSyntax() {
        ExpressionIllegalSyntaxException e1 = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("${file.name}", ""), (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e1.getMessage().startsWith("Unknown function: file.name at location 0"));
        ExpressionIllegalSyntaxException e2 = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("hey ${xxx} how are you?", ""), (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e2.getMessage().startsWith("Unknown function: xxx at location 4"));
        ExpressionIllegalSyntaxException e3 = (ExpressionIllegalSyntaxException)Assertions.assertThrows(ExpressionIllegalSyntaxException.class, () -> this.assertExpression("${xxx}", ""), (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e3.getMessage().startsWith("Unknown function: xxx at location 0"));
    }

    @Test
    public void testConstantFilename() {
        this.assertExpression(TEST_FILE_NAME_1, TEST_FILE_NAME_1);
    }

    public static class MyFileNameGenerator {
        public String generateFilename(Exchange exchange) {
            return "generatorbybean";
        }
    }
}

