/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.Message;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.language.bean.BeanExpression;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanTest
extends LanguageTestSupport {
    @Test
    public void testSimpleExpressions() {
        this.assertExpression("foo.echo('e::o')", "e::o");
        this.assertExpression("foo.echo('e.o')", "e.o");
        this.assertExpression("my.company.MyClass::echo('a')", "a");
        this.assertExpression("my.company.MyClass::echo('a.b')", "a.b");
        this.assertExpression("my.company.MyClass::echo('a::b')", "a::b");
        this.assertExpression("foo.cheese", "abc");
        this.assertExpression("foo?method=cheese", "abc");
        this.assertExpression("my.company.MyClass::cheese", "abc");
        this.assertExpression("foo?method=echo('e::o')", "e::o");
    }

    @Test
    public void testPredicates() {
        this.assertPredicate("foo.isFooHeaderAbc");
        this.assertPredicate("foo?method=isFooHeaderAbc");
        this.assertPredicate("my.company.MyClass::isFooHeaderAbc");
    }

    @Test
    public void testDoubleColon() {
        this.assertPredicate("foo::isFooHeaderAbc");
        NoSuchBeanException e = (NoSuchBeanException)Assertions.assertThrows(NoSuchBeanException.class, () -> this.assertPredicateFails("foo:isFooHeaderAbc"), (String)"Should throw exception");
        Assertions.assertEquals((Object)"foo:isFooHeaderAbc", (Object)e.getName());
    }

    @Test
    public void testBeanTypeExpression() {
        BeanExpression exp = new BeanExpression(MyUser.class, null);
        exp.init((CamelContext)this.context);
        Exchange exchange = this.createExchangeWithBody("Claus");
        Object result = exp.evaluate(exchange, Object.class);
        Assertions.assertEquals((Object)"Hello Claus", (Object)result);
    }

    @Test
    public void testBeanTypeAndMethodExpression() {
        BeanExpression exp = new BeanExpression(MyUser.class, "hello");
        exp.init((CamelContext)this.context);
        Exchange exchange = this.createExchangeWithBody("Claus");
        Object result = exp.evaluate(exchange, Object.class);
        Assertions.assertEquals((Object)"Hello Claus", (Object)result);
    }

    @Test
    public void testBeanInstanceAndMethodExpression() {
        MyUser user = new MyUser();
        BeanExpression exp = new BeanExpression((Object)user, "hello");
        exp.init((CamelContext)this.context);
        Exchange exchange = this.createExchangeWithBody("Claus");
        Object result = exp.evaluate(exchange, Object.class);
        Assertions.assertEquals((Object)"Hello Claus", (Object)result);
    }

    @Test
    public void testNoMethod() {
        MyUser user = new MyUser();
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            BeanExpression exp = new BeanExpression((Object)user, "unknown");
            exp.init((CamelContext)this.context);
        }, (String)"Should throw exception");
        MethodNotFoundException mnfe = BeanTest.assertIsInstanceOf(MethodNotFoundException.class, e);
        Assertions.assertSame((Object)user, (Object)mnfe.getBean());
        Assertions.assertEquals((Object)"unknown", (Object)mnfe.getMethodName());
    }

    @Test
    public void testNoMethodBeanLookup() {
        MethodNotFoundException e = (MethodNotFoundException)Assertions.assertThrows(MethodNotFoundException.class, () -> {
            BeanExpression exp = new BeanExpression("foo", "cake");
            exp.init((CamelContext)this.context);
        }, (String)"Should throw exception");
        Assertions.assertEquals((Object)"cake", (Object)e.getMethodName());
    }

    @Override
    protected String getLanguageName() {
        return "bean";
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("foo", (Object)new MyBean());
        answer.bind("my.company.MyClass", (Object)new MyBean());
        return answer;
    }

    public static class MyUser {
        public String hello(String name) {
            return "Hello " + name;
        }
    }

    public static class MyBean {
        public Object cheese(Exchange exchange) {
            Message in = exchange.getIn();
            return in.getHeader("foo");
        }

        public String echo(String echo) {
            return echo;
        }

        public boolean isFooHeaderAbc(@Header(value="foo") String foo) {
            return "abc".equals(foo);
        }
    }
}

