/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class BeanLanguageOGNLWithDotInParameterTest
extends ContextTestSupport {
    @Test
    public void testDot() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("goto", (Object)"mock:MyAppV1.2.3/blah");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myBean", (Object)new MyDestinationBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setHeader("goto").simple("${bean:myBean?method=whereToMate('MyAppV1.2.3', 'blah')}")).to("mock:result");
            }
        };
    }

    public static class MyDestinationBean {
        public String whereToMate(String version, String id) {
            return "mock:" + version + "/" + id;
        }
    }
}

