/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class BeanLanguageOGNLWithDotInParameterPropertyPlaceholderTest
extends ContextTestSupport {
    @Test
    public void testDot() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("goto", (Object)"mock:MyAppV1.2.3/blah");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "id", (Object)"blah");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myBean", (Object)new MyDestinationBean());
        Properties myProp = new Properties();
        myProp.put("myApp", "MyAppV1.2.3");
        jndi.bind("myprop", (Object)myProp);
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("ref:myprop");
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setHeader("goto").simple("${bean:myBean.whereToMate({{myApp}}, ${header.id})}")).to("mock:result");
            }
        };
    }

    public static class MyDestinationBean {
        public String whereToMate(String version, String id) {
            return "mock:" + version + "/" + id;
        }
    }
}

